'''
This is a collection of utilities for testing.
Author: Danver Braganza
'''


class TestStub(object):
    '''
    This class is a stub for use in testing.
    Bit of a reinventing the wheel, if you will, but I wanted the practice.
    All method calls on this object return false, and update an internal log
    This class can be initialised with a list of return values, which all methods
    will return IN ORDER
    '''

    class Watcher(object):
        def __init__(self, owner, s):
            self._owner = owner
            self._name = s
        def __call__(self, *args):
            self._owner._log.append('%s%s' % (self._name, args[0:]))
            if self._owner._values:
                return self._owner._values.pop(0)
            else:
                return 5

    def __init__(self, values=[]):
        self._log = []
        self._values = values
    def __getattribute__(self, name):
        if name == '_log':
            return object.__getattribute__(self, '_log')
        elif name == '_values':
            return object.__getattribute__(self, '_values')
        else:
            return TestStub.Watcher(self, name)

class StreamMocker(object):
    '''
    This class is used to mock a filestream object, for reading from.
    '''
    def __init__(self, *strings):
        self._strings = strings
        self._count = -1
    
    def readline(self):
        self._count += 1
        if len(self._strings) == self._count:
            raise StopIteration
        return self._strings[self._count]
