"""
Purpose: This suite of tests is intended to test the correctness of
         the weighted graph implementations within the graphtypes module.
Author:  Danver Braganza
Date:    20th Jan, 2010
"""
import unittest

from graphadt.graphtypes import WeightedDirectedAdjListsGraph, WeightedUndirectedAdjListsGraph


def suite():
    """
    Returns a suite of all TestCases defined in this module
    """
    # Load all the tests from this module
    return unittest.TestLoader().loadTestsFromName(__name__)


class BasicTests(object):
    """These tests check that all method calls on Graph object have the right behaviour.
    """

    def testAddVertices(self):
        self.g.addVertices(1)
        assert self.g.order() == 1
        assert self.g.size() == 0

    def testAScenario(self):
        """A very bad way to write a test case, but I need to get this done quickly.

        This is NOT a unit test, but a test scenario.  If I have more time, I will come back
        and redo these tests.

        Update(2020-07-24): See, kids, this is how software development works in
        practice. You say you'l come back and do something, and you rarely
        do.
        """
        self.g.addVertices(2)
        self.g.addEdge(1, 1)
        assert self.g.order() == 2
        assert self.g.size() == 1
        assert self.g.getArcWeight(1, 1) == 0
        self.g.setArcWeight(1, 1, 50)
        assert self.g.getArcWeight(1, 1) == 50
        self.g.removeVertex(0)
        assert self.g.order() == 1
        assert self.g.size() == 1
        assert self.g.getArcWeight(0, 0) == 50
        self.g.addVertices(1)
        self.g.addEdge(1, 1)
        assert self.g.getArcWeight(1, 1) == 0
        self.g.setArcWeight(1, 1, 50)
        self.g.removeEdge(1, 1)
        self.g.addEdge(1, 1)
        assert self.g.getArcWeight(1, 1) == 0


class DirectedTests(unittest.TestCase, BasicTests):
    def setUp(self):
        self.g = WeightedDirectedAdjListsGraph()


class UndirectedTests(unittest.TestCase, BasicTests):
    def setUp(self):
        self.g = WeightedUndirectedAdjListsGraph()  # Default constructor, leaves graph empty


if __name__ == "__main__":
    unittest.main()
