#! /usr/bin/env python

import sys
from graphadt.graphtypes import *

def bestScore(g, v, weight=0):
    '''
    You have to tell v the weight you're looking at it from

    The best score in g is the max of:
    straight through v : one of v's children's straight-through + it's weights
    hairpin on v       : two of v's children's straight-throughs + their weights
    not including v    : one of v's children's hairpins or not-includings
    '''

    score = {} # score is a dictionary keeping track of the three values

    through = weight       # These are 
    notincluding = 0       # currently found
    hairpin = []           # maxima
    for i in g.neighbours(v):                          # For each neighbour
        bs = bestScore(g, i, g.getArcWeight(v, i))     # Get its best scores
        through = max(through, bs['through'] + weight) # Does it beat our through score?
        hairpin.append(bs['through'])                  # note it for our hairpin
        notincluding = max(notincluding, bs['notincluding'], bs['hairpin'])
                                                       # Does it have a better score somewhere lower?
    if not hairpin:
        # if the list is empty, the value of a hairpin bend is 0
        hairpin = 0
    else:
        # Calculate the hairpin bend
        hairpin = sum(sorted(hairpin)[-1:-3:-1])  # Trust me
        
    score['through'] = through                    # bundle them up
    score['hairpin'] = hairpin                    
    score['notincluding'] = notincluding
        
    return score                                  # and return them
    

while True: 
    #read in number of intersections
    n = int(sys.stdin.readline())
    if n == 0:
        break   # If n is 0, we're done
    g = WeightedDirectedAdjListsGraph()
    g.addVertices(n)
    values = []                                                       # slow, bad code because I don't want
    while len(values) < (n - 1) * 2:                                  # to read this in 
        values.extend(map(int, sys.stdin.readline().strip().split())) # properly
        # chuck on   integers from reading in a line and splitting it 

    values = zip(values[0::2], values[1::2]) # collect values into pairs

    for to, (fro, weight) in enumerate(values):
        g.addArc(fro, to + 1)
        g.setArcWeight(fro, to + 1, weight)
    
    bs = bestScore(g, 0)
    print max(bs.values())

            
            

    
