/* Tree Algorithms :
 * this class contains three different Isomorphism tests; 
 * one for Unrooted Trees,  another for Rooted Trees, 
 * and a third for Ordered Trees.
 */

package treeAlgs;

import treeADT.*;
import java.util.*;

public class TreeAlgs {
	
	/* finds the center of an unrooted tree, also known as the primary root
	 */
	public static ArrayList<Integer> centers(UnrootedTree T){
		int n = T.order();
		int c1, c2;
		int[] deg = new int[n];
		for (int i=0; i<n; i++) deg[i]=T.degree(i);

		int cnt=0;
		while (cnt < n-2){
			ArrayList<Integer> leaves = new ArrayList<Integer>();
			for (int j=0; j<n; j++){
				if (deg[j]==1) {
					leaves.add(j);
					deg[j]=-1; cnt++;
				}
			}
			for (int j=0; j<leaves.size(); j++){
				for (int k=0; k<T.degree(leaves.get(j)); k++) {
					int d = deg[T.neighbors(leaves.get(j)).get(k)];
					if (d>0) deg[T.neighbors(leaves.get(j)).get(k)] = d-1;
				}
			}
		}
		assert (cnt==n-1 || cnt==n-2);
		c1 = c2 = -1;
		for (int i=n-1; i>=0; i--){
			if (deg[i]==1) { if (cnt++ == n-2) c2=i; else c1=i; }
			if (deg[i]==0) { assert(cnt==n-1); c1=i; }
		}

		ArrayList<Integer> roots = new ArrayList<Integer>();
		roots.add(c1);
		if (c2 != -1) roots.add(c2);
		return roots;
	}

	/* Wrapper class for ArrayList<Integer>,
	 * allows for use of Arrays.Sort in the getCertificate method
	 */
	public static class Cert implements Comparable<Cert>{
		public ArrayList<Integer> certificate;

		public Cert() { certificate = new ArrayList<Integer>();}

		public int compareTo(Cert other) {
			int i = 0;
			while(i < Math.min(certificate.size(), other.certificate.size())-1 && certificate.get(i )  == other.certificate.get(i )){
				i++;
			}
			int difference =  certificate.get(i)  - other.certificate.get(i); //change to other.cert - cert if wrong
			if (difference == 0) {
				// same length, same number
				return certificate.size() - other.certificate.size();
			}
			return difference;
		}

		public String toString(){
			StringBuffer o = new StringBuffer();
			o.append("(");
			for (int i : certificate){
				o.append(i + ", ");
			}
			o.append(")");
			return o.toString();
		}
	}
	/* End Wrapper class Cert */


	public static Cert getCertificate(UnrootedTree T, int r, boolean[] seen){
		assert(seen[r]==false);
		seen[r]=true;

		ArrayList<Cert> seq = new ArrayList<Cert>();
		for (int i=0; i < T.degree(r); i++){
			List<Integer> N = T.neighbors(r);
			if (seen[N.get(i)] == false){
				seq.add(getCertificate(T, N.get(i), seen));
			}
		}

		Cert[] cs = new Cert[seq.size()];
		cs = seq.toArray(cs);
		Arrays.sort(cs);

		Cert cert = new Cert();

		cert.certificate.add(0); // root

		for (int j=0; j<seq.size(); j++){
			for (int k=0; k<seq.get(j).certificate.size(); k++){
				cert.certificate.add(seq.get(j).certificate.get(k)+1); /*cert.push_back(seq[j].at(k)+1);*/
			}
		}
		return cert;
	}

	/* Rooted Tree Isomorphism
	 *
	 */
	public static boolean isIso(RootedTree T1, RootedTree T2){
		int r1 = T1.getRootIndex();
		int r2 = T2.getRootIndex();

		int n1 = T1.order();
		int n2 = T2.order();

		if (n1 != n2) return false;

		boolean[] seen1 = new boolean[n1];
		boolean[] seen2 = new boolean[n2];

		Cert c1 = getCertificate(T1, r1, seen1);
		Cert c2 = getCertificate(T2,r2, seen2);

		for (int i=0; i<c1.certificate.size(); i++){
			if (c1.certificate.get(i)!=c2.certificate.get(i)) {
				return false;
			}
		}
		return true;
	}

	/* Unrooted Tree Isomorphism
	 *
	 */
	public static boolean isIso(UnrootedTree one, UnrootedTree two){

		ArrayList<Integer> one_rootSet = centers(one);
		ArrayList<Integer> two_rootSet = centers(two);

		//one of the trees has a single center when the other does not.
		if(one_rootSet.size() != two_rootSet.size()) return false;


		if(one_rootSet.size() ==1){
			RootedTree rOne = new rTree(one);
			rOne.setRoot((int)one_rootSet.get(0));
			RootedTree rTwo = new rTree(two);
			rTwo.setRoot((int)two_rootSet.get(0));
			return isIso(rOne, rTwo);
		}else{ //try the permutations
			//first root of both
			RootedTree rOne = new rTree(one);
			rOne.setRoot((int)one_rootSet.get(0));
			RootedTree rTwo = new rTree(two);
			rTwo.setRoot((int)two_rootSet.get(0));
			boolean firsttry = isIso(rOne, rTwo);
			if(firsttry){
				return true;
			}else{
				rTwo.setRoot((int)two_rootSet.get(1));
				return isIso(rOne, rTwo);
			}
		}

	}


	/* Ordered Tree Isomorphism
	 *
	 */
	public static boolean isIso(OrderedTree one, OrderedTree two){
		int order_one = one.order();
		int order_two = two.order();

		if((order_one == 1) && (order_two== 1)){
			return true; //both trees are a single node.
		}else if(order_one == 1){
			return false; //tree one is a single node, and two isn't.
		}else if(order_two== 1){
			return false; //tree two is a single node, and one isn't.
		}else if(order_one != order_two){
			return false; //can't be isomorphic if the orders don't match
		}else{
			//check the permutations of the subtrees.
			List<OrderedTree> sub_one = one.oSubtrees(one.getRootIndex());
			List<OrderedTree> sub_two = two.oSubtrees(two.getRootIndex());

			int children_one = sub_one.size();
			int children_two = sub_two.size();

			if(children_one != children_two) return false; // out-degree is not equal

			for(int i = 0; i < children_one; i++){		//the subtrees at i have to match
				if(isIso(sub_one.get(i), sub_two.get(i))){
					//try the next one
				}else{
					return false;			//circuit breaker.
				}
			}
			return true;

		}

	}
	/* test to make sure the sort, sorts correctly.
	 */
	public static void main(String[] args){
		//just to test the Cert class
		//E.g. ((3,5),(2,3,5),(2,3),(3,4)) --> ((2,3),(2,3,5),(3,4),(3,5))
		Cert c1 = new Cert();
		c1.certificate.add(3);
		c1.certificate.add(5);

		Cert c2 = new Cert();
		c2.certificate.add(2);
		c2.certificate.add(3);
		c2.certificate.add(5);

		Cert c3 = new Cert();
		c3.certificate.add(2);
		c3.certificate.add(3);

		Cert c4 = new Cert();
		c4.certificate.add(3);
		c4.certificate.add(4);

		ArrayList<Cert> certArray= new ArrayList<Cert>();
		certArray.add(c1);
		certArray.add(c2);
		certArray.add(c3);
		certArray.add(c4);

		for(Cert i : certArray){
			System.out.println(i);
		}

		Cert[] cs = new Cert[certArray.size()];
		cs = certArray.toArray(cs);
		Arrays.sort(cs);

		System.out.println("after sorting");
		for (int j = 0; j < cs.length; j++){
			System.out.println(cs[j]);
		}

	}
}
