/*
 * A simple unrooted tree class. The current implementation uses
 * adjacency lists form of a tree.
 *
 * @author mjd@cs.auckland.ac.nz
 * @author alexei@cs.auckland.ac.nz
 *
 * Edit Log:
 * Initialized subtrees' parents[] in method subtrees (05-July-2007)
 */

 //update - StringTokenizer gone, also changed random for loops to for each loops
 //       - Note: haven't tested anything.
package treeADT;

import java.io.*;
import java.util.*;

public class uTree implements UnrootedTree{
    //  Internal Representation and Constructors
    //
	protected List<List<Integer>> adj;   // List of Lists of Integers
	protected List<Object> obj;     // User defined labels for nodes.

	public uTree(UnrootedTree T){ // copy constructor
		int n = T.order();
		adj = new ArrayList<List<Integer>>();
		obj = new ArrayList<Object>();
        for (int i = 0; i < n; i++){
            adj.add(T.neighbors(i));
            obj.add(T.getObject(i));
        }
    }

    public uTree(Object label){   // create a tree with one vertex
        adj = new ArrayList<List<Integer>>();
        adj.add(new ArrayList<Integer>());
        obj = new ArrayList<Object>();
        obj.add(label);
    }

    // create a tree by adding edge between nodes of two trees
    //
    public uTree(UnrootedTree T1, int v1, UnrootedTree T2, int v2){
        int n1 = T1.order();
        int n2 = T2.order();
        adj = new ArrayList<List<Integer>>();
        obj = new ArrayList<Object>();

        assert(v1 >= 0 && v1 < n1);
        assert(v2 >= 0 && v2 < n2);

        for (int i = 0; i < n1; i++){
            adj.add(T1.neighbors(i));
            obj.add(T1.getObject(i));
        }

        for (int i = 0; i < n2; i++){
            List<Integer> adj2 = new ArrayList<Integer>();
            for (int nbr : T2.neighbors(i)){
                adj2.add(nbr + n1);
            }
            adj.add(adj2);
            obj.add(T2.getObject(i));
        }

        adj.get(v1).add(n1 + v2);
        adj.get(n1 + v2).add(v1);
    }

    public uTree(BufferedReader buffer){  // adjacency list (Integer objects)
        try{
            String line = buffer.readLine();
            String[] tokens = line.split("\\s+");
            if (tokens.length != 1)
                throw new Error("bad format: number of vertices");

            int n = Integer.parseInt(tokens[0]);
            adj = new ArrayList<List<Integer>>();
            obj = new ArrayList<Object>();

            for (int u = 0; u < n; u++){
                adj.add(new ArrayList<Integer>());
                obj.add(u);

                line = buffer.readLine();
                tokens = line.split("\\s+");

                for(String s : tokens){
                    int v = Integer.parseInt(s);
                    adj.get(u).add(v);
                }
            }
        }catch (IOException x){
            throw new Error("bad input stream");
        }
    }

    //  Mutator Methods
    //
	//convenience method (same as adding edge between a tree and one of one node).
    public void addLeaf(Object label, int v){
        int n = order();
        assert(v >= 0 && v < n);

        adj.add(new ArrayList<Integer>());
        obj.add(label);

        adj.get(n).add(v);
        adj.get(v).add(n);
    }


    //convenience method (same as splitting tree edge and rejoining three trees)
    public void subdivideEdge(Object label, int u, int v){
        int n = order();
        assert(isEdge(u, v));

        adj.add(new ArrayList<Integer>());
        obj.add(label);

        List<Integer> uu = adj.get(u);
        // can't rely on auto-boxing here because of overloaded methods in List
        uu.remove(new Integer(v));      // remove v from u's adj list
        uu.add(n);

        List<Integer> vv = adj.get(v);
        // can't rely on auto-boxing here because of overloaded methods in List
        vv.remove(new Integer(u));      // remove u from v's adj list
        vv.add(n);

        adj.get(n).add(u);
        adj.get(n).add(v);
    }



	//convenience method (same as splitting at tree edge adjacent to leaf)
    public void removeLeaf(int i){
		assert(0 <= i && i < order());
        assert(degree(i) == 1);

        adj.remove(i);
        obj.remove(i);

        Integer I = new Integer(i);
        for (int u = 0; u < order(); u++){
            List<Integer> uu = adj.get(u);
            uu.remove(I);          // remove i from adj lists

            for (Integer nbr : uu){ // relabel larger indexed nodes
                if (nbr > i){
					int index = uu.indexOf(nbr);
					uu.set(index, nbr - 1);
				}
            }
        }
    }

    public void setObject(int i, Object objIn){
		assert(0 <= i && i < order());
        obj.set(i, objIn);
    }

    //  Access Methods
    //
    public boolean isEdge(int i, int j){
		assert(0 <= i && i < order());
		assert(0 <= j && j < order());
        assert(i != j);
        return adj.get(i).contains(j);
    }

    public Object getObject(int i){
        assert(0<= i && i < order());
        return obj.get(i);
    }

    public int degree(int i){
		assert(0 <= i && i < order());
        return adj.get(i).size();
    }

    public List<Integer> neighbors(int i){
		assert(0 <= i && i < order());
    	List<Integer> nbrs = adj.get(i);
    	List<Integer> nei = new ArrayList<Integer>();

    	for( Integer j : nbrs){
    		nei.add(j);
    	}
    	return nei;
    }

    public int order(){
        return adj.size();
    }

    public int size(){
        return order() - 1;
    }

    //  Utility Methods
    // 
    // default output readable by constructor
    //
    static String EOL = System.getProperty("line.separator");
    public String toString(){
        StringBuffer o = new StringBuffer();
        o.append(order()).append(EOL);

        for (int i = 0; i < order(); i++){
            List<Integer> N = neighbors(i);
            if  (N.size()==1) o.append(getObject(i)+": ");
            for (Integer aN : N){
                o.append(aN).append(" ");
            }
            o.append(EOL);
        }
        return o.toString();
    }

    // get set of trees induced by neighbors of a given vertex
    //
    public List<UnrootedTree> subtrees(int u){
        int n = order();
        assert(u < n);

        int[] parent = new int[n];
        int[] mapping = new int[n];
        parent[u] = u + 1; // reserve 0 to indicate it is not determined

        List<UnrootedTree> S = new ArrayList<UnrootedTree>();

        List<Integer> snbrs = neighbors(u);
        for (Integer v : snbrs){
            parent[v] = v+1;  		// bug fix: no parent for me
            uTree T = new uTree(getObject(v));
            int cnt = 0;
            mapping[v] = cnt++;

            LinkedList<Integer> toGrow = new LinkedList<Integer>();
            toGrow.addLast(v);

            while (toGrow.peek() != null){
                int grow = toGrow.removeFirst();
                List<Integer> nbrs = neighbors(grow);

                for (Integer w : nbrs){
                    if (parent[w] == 0){
                        parent[w] = grow + 1;
                        toGrow.addLast(w);
                        T.addLeaf(getObject(w), mapping[grow]);
                        mapping[w] = cnt++;
                    }
                }
            }
            S.add(T);
        }
        return S;
    }

    // get two trees by splitting tree at an edge
    //
    public List<UnrootedTree> splitEdgeTrees(int u, int v){
        int n = order();
        assert(isEdge(u, v));

        int[] parent = new int[n];
        int[] mapping = new int[n];
        parent[u] = v + 1; // reserve 0 to indicate not set
        parent[v] = u + 1;

        uTree T1 = new uTree(getObject(u));
        int cnt = 0;
        mapping[u] = cnt++;

        LinkedList<Integer> toGrow = new LinkedList<Integer>();
        toGrow.addLast(u);

        while (toGrow.peek() != null){
            int grow = toGrow.removeFirst();
            List<Integer> nbrs = neighbors(grow);

            for (Integer w : nbrs){
                if (parent[w] == 0){
                    parent[w] = grow + 1;
                    toGrow.addLast(w);
                    T1.addLeaf(getObject(w), mapping[grow]);
                    mapping[w] = cnt++;
                }
            }
        }

        uTree T2 = new uTree(getObject(v));
        cnt = 0;
        mapping[v] = cnt++;

        toGrow = new LinkedList<Integer>();
        toGrow.addLast(v);

        while (toGrow.peek() != null){
            int grow = toGrow.removeFirst();
            List<Integer> nbrs = neighbors(grow);

            for (Integer w : nbrs){
                if (parent[w] == 0){
                    parent[w] = grow + 1;
                    toGrow.addLast(w);
                    T2.addLeaf(getObject(w), mapping[grow]);
                    mapping[w] = cnt++;
                }
            }
        }
        assert(T1.order() + T2.order() == n);

        ArrayList<UnrootedTree> S = new ArrayList<UnrootedTree>();
        S.add(T1);
        S.add(T2);
        return S;
    }
}
