/*Implements RootedTree extends UnrootedTree
 * similar to the UnrootedTree but now stores a root index.
 */
package treeADT;

import java.util.*;
import java.io.*;


public class rTree extends uTree implements RootedTree{
	protected int rootIndex;

	public rTree(UnrootedTree T){ // copy constructor
		super(T);
		rootIndex = 0;
    }
	public rTree(RootedTree T){ // copy constructor
		super(T);
		rootIndex = T.getRootIndex();
    }

    public rTree(Object label){   // create a tree with given object as root
        super(label);
    	rootIndex = 0;
    }

    public rTree(BufferedReader buffer){  	// adjacency list (Integer objects)
    	super(buffer);
    	rootIndex = 0;						//sets default root to be the 0 node.

    }

    public int getRootIndex(){
		return rootIndex;
	}

    public Object getRootObject(){
		return getObject(rootIndex);
	}

    public void setRoot(int i){
		assert(0 <= i && i < order());
		rootIndex = i;
	}

    public void setRoot(Object o){
		setObject(rootIndex, o);
	}


    public int[] getParents(int root){
    	//code adapted from GraphAlgs getBFSParents
		int n = order();
		int[] parent = new int[n];
		for (int i=0; i<n; i++) parent[i]=-1;
		parent[root]=root;	// root is its own parent

		LinkedList<Integer> toGrow = new LinkedList<Integer>();
		toGrow.addLast(new Integer(root));

		while (toGrow.peek() != null){
			int grow = toGrow.removeFirst();
			List<Integer> nbrs = neighbors(grow);

			for (int i : nbrs){
				if (parent[i] == -1){
					parent[i] = grow;
					toGrow.addLast(new Integer(i));
				}
			}
		}
		return parent;
    }


    public List<RootedTree> rSubtrees(int i){
		assert(0 <= i && i < order());
    	int[] pars = getParents(rootIndex); 	//return the subtrees just like the unrooted tree,
    										//but with the parent subtree removed.
    	int par = pars[i];
        int n = order();
        int u = i;								//unrooted subtree method alteration.

        int[] parent = new int[n];
        int[] mapping = new int[n];
        parent[u] = u + 1; // reserve 0 to indicate it is not determined

        List<RootedTree> S = new ArrayList<RootedTree>();

        List<Integer> snbrs = neighbors(u);
        for (Integer v : snbrs){
			if (v != par || i == rootIndex){			//if the 'subtree' is the parent do nothing.
				parent[v] = v+1;  		// bug fix: no parent for me
				rTree T = new rTree(getObject(v));
				int cnt = 0;
				mapping[v] = cnt++;

				LinkedList<Integer> toGrow = new LinkedList<Integer>();
				toGrow.addLast(v);

				while (toGrow.peek() != null){
					int grow = toGrow.removeFirst();
					List<Integer> nbrs = neighbors(grow);

					for (Integer w : nbrs){
						if (parent[w] == 0){
							parent[w] = grow + 1;
							toGrow.addLast(w);
							T.addLeaf(getObject(w), mapping[grow]);
							mapping[w] = cnt++;
						}
					}
				}
				S.add(T);
			}
		}
        return S;
	}
}
