/*ordered tree extends rooted tree
 * in lists representation
 */

package treeADT;

import java.io.*;
import java.util.*;


public class oTree extends rTree implements OrderedTree{

	public oTree(OrderedTree T){ // copy constructor
		super(T);
    }

    public oTree(Object label){   // create a tree with given object as root
        super(label);
    }

    public oTree(BufferedReader buffer){  	// adjacency list (Integer objects)
    	super(buffer);
    }
    
    public void addSpecificNeighbor(int parent, int index, Object childLabel){
    	assert(0 <= parent && parent < order());
    	assert(0 <= index && index < adj.get(parent).size());
    	adj.get(parent).add(index, order());
    	obj.add(childLabel);
    }
    
    
    public void setSpecificNeighbor(int parent, int index, int child){
    	assert(0 <= parent && parent < order());
    	int[] parents = getParents(rootIndex);
    	int childParent = parents[child];
    	//remove the child from the current parent
    	adj.get(childParent).remove(new Integer(child));
    	
    	//replace the old parent with the new parent (ordering matters)
    	int place = adj.get(child).indexOf(new Integer(childParent));
    	adj.get(child).set(place, parent);
    	
    	//obj child index remains the same.
    	//add the child to the new parent at given index
    	adj.get(parent).add(index, child); 
    }
    
    public int getSpecificNeighborIndex(int parent, int index){
		assert(0 <= parent && parent < order());
		assert(0 <= index && index < adj.get(parent).size());
    	return adj.get(parent).get(index);
    }
    public Object getSpecificNeighborObject(int parent, int index){
    	return adj.get(parent).get(index);
    }
    
    public List<OrderedTree> oSubtrees(int i){
		assert(0 <= i && i < order());
    	int[] pars = getParents(rootIndex);
    	
    	int par = pars[i]; 	//return the subtrees just like the unrooted tree,
		//but with the parent subtree removed.

		int n = order();
		int u = i;								//unrooted subtree method alteration.
		
		int[] parent = new int[n];
		int[] mapping = new int[n];
		parent[u] = u + 1; // reserve 0 to indicate it is not determined
		
		List<OrderedTree> S = new ArrayList<OrderedTree>();
		
		List<Integer> snbrs = neighbors(u);
		for (Integer v : snbrs){
			if (v != par){			//if the 'subtree' is the parent do nothing.
				parent[v] = v+1;  		// bug fix: no parent for me
				oTree T = new oTree(getObject(v));
				int cnt = 0;
				mapping[v] = cnt++;
				
				LinkedList<Integer> toGrow = new LinkedList<Integer>();
				toGrow.addLast(v);
				
				while (toGrow.peek() != null){
					int grow = toGrow.removeFirst();
					List<Integer> nbrs = neighbors(grow);
					
					for (Integer w : nbrs){
						if (parent[w] == 0){
							parent[w] = grow + 1;
							toGrow.addLast(w);
							T.addLeaf(getObject(w), mapping[grow]);
							mapping[w] = cnt++;
						}
					}
				}
				S.add(T);
			}
		}
		return S;
    }
}
