/* An interface defining an unrooted tree with node indexed by integers.
 * an unrooted tree is an acyclic graph.
 * -modified Alexeis code
 */
package treeADT;

import java.util.List;

public interface UnrootedTree{

    //returns the degree of the i'th node.
    int degree(int i);

    //returns the object associated with the i'th node.
    Object getObject(int i);


    //Sets the object at the i'th node.
    void setObject(int i, Object obj);

    //return true if there is an edge directly connecting node i and node j.
    boolean isEdge(int i, int j);

    //returns a list of neighbors of the immediate neighbors of the i'th node.
    List<Integer> neighbors(int i);

    //returns the number of nodes in the tree.
    int order();

    //returns the number of edges in the tree.
    int size();
    
    //removes a node of degree 1 (or a leaf) within the tree
    void removeLeaf(int i);
    
    //returns the two resulting trees when the edge u,v is deleted.
    List<UnrootedTree> splitEdgeTrees(int u, int v);
}
