/*The rootedTree interface
 *  extends unrootedTree
 *  the rooted tree is an acyclic graph with a 'root' or arbitrary center.
 *  the root is used to infer parent-child relationships from edges.
 */


package treeADT;

import java.util.List;

public interface RootedTree extends UnrootedTree{

    //returns the index of the root of the rooted tree
    int getRootIndex();

    //gets the root object in the rooted tree
    Object getRootObject();

    //sets the root index in the rooted tree, creating a new root
    void setRoot(int i);

     //sets the root object in the rooted tree at the root index
    void setRoot(Object o);


	//returns a set of rootedTrees with i as the root.
    List<RootedTree> rSubtrees(int i);
    
    
    //returns the immediate parent of all nodes; when passed in the root of the tree
    //takes in the root if you were considering changing the current root and wanted to
    //find out what the immediate parent of child i is if you passed in a node that isnt the
    //[main] root
    int[] getParents(int root);
}
