/*The ordered tree interface, extends rootedTree which extends unrootedTree
 * an ordered tree is basically a rooted tree where the ordering of the neighbours matter
 */

package treeADT;
import java.util.*;

public interface OrderedTree extends RootedTree{
	
	
	//creates a new node with the label provided and adds it as the parents index'th child
	void addSpecificNeighbor(int parent, int index, Object childLabel);
    
	//sets the child as the index-ith neighbour of the parent. after removing it from its old parent
	void setSpecificNeighbor(int parent, int index, int child);

	//returns the node index of the index-ith neighbor of the parent.
    int getSpecificNeighborIndex(int parent, int index);

    
    //returns the object held by a specific child of the parent provided
    Object getSpecificNeighborObject(int parent, int index);
    
    //returns the subtrees of i as OrderedTree's
    List<OrderedTree> oSubtrees(int i); 
    
}
