/*Isomorphism check for graphs.
 * -may move the isIso method into the GraphAlgs class
 */

package graphAlgs;

import graphADT.*;

public class Isomorphism{
	public static boolean isIso(Graph one, Graph two, int[] mapOne, int[] mapTwo){
		//convert the graphs into the int[][] arrays
		int n = one.order();
		if (n != two.order()) return false;

		int[][] matrix_one = new int[n+1][n+1];
		int[][] matrix_two = new int[n+1][n+1];

		for(int i = 0; i < n; i++){
			for (int j = 0; j < n; j++){
				if(one.isArc(i,j)) matrix_one[i+1][j+1] = 1;
				if(two.isArc(i,j)) matrix_two[i+1][j+1] = 1;
			}
		}

		int[] map_one = new int[n+1];
		int[] map_two = new int[n+1];

		int toReturn = graphIsomorphism(n, matrix_one, matrix_two, map_one, map_two);
		//System.out.println("toReturn = " + toReturn);

		if (toReturn == 0)
			for(int i = 0; i < n; i++){
				mapOne[i] = map_one[i+1] -1;
				mapTwo[i] = map_two[i+1] -1;
			}
		return  toReturn == 0;
	}
	/*
	 * Returns:
	 * if 0) True the graphs are isomorphic
	 * if 1) False edge counts do not match
	 * if 2) False outdegree histograms do not match
	 * if 3) False isomorphic codes do not match
	 * if 4) False one of the graphs does not produce isomorphic code
	 */
	public static int graphIsomorphism(int n, int adj1[][], int adj2[][],int map1[], int map2[]){

		int i,j,k,edges1,edges2;
		int label1[][] = new int[n + 1][n + 1];
		int label2[][] = new int[n + 1][n + 1];
		int degree1[] = new int[n + 1];
		int degree2[] = new int[n + 1];
		//validate the number of edges
		edges1 = 0;
		edges2 = 0;
		for (i=1; i<=n; i++){
			for (j=1; j<=n; j++){
				//don't allow cycles to yourself.
				edges1 += adj1[i][j];
				edges2 += adj2[i][j];
				//edges1 = (i == j) ? edges1 + 2 * adj1[i][j] : edges1 + adj1[i][j];
			}
		}
		//edges1 /= 2; not just uGraphs
		//edges2 /= 2; not just uGraphs
		if (edges1 != edges2 ) return 1;
		//validate the degree sequences
		//node degrees of the first graph are ordered in decreasing order
		//node degree of the second graph are ordered in decreasing order
		for (i=1; i<=n; i++){
			for (j=1; j<=n; j++){
				degree1[i] += adj1[i][j];
				degree2[i] += adj2[i][j];
			}
		}
		//sort "degree1" in descending order
		heapsort(n, degree1, false);
		//sort "degree2" in descending order
		heapsort(n, degree2, false);
		//compare the degree sequence of the two graphs
		k = 1;
		while (k <= n) {
			if (degree1[k] != degree2[k]) return 2; //changed < to !=
			k++;
		}

		//compute the code of the first graph
		if (!isomorphicCode(adj1, n, label1, map1)) return 4;

		//compute the code of the second graph
		if (!isomorphicCode(adj2, n, label2, map2)) return 4;

		//compare the codes of the two graphs
		for (j=1; j<=n; j++){
			for (i=1; i<=n; i++){
				if (label1[i][j] != label2[i][j]) return 3;
			}
		}
		return 0;
	}



	private static boolean isomorphicCode(int adj[][], int n, int label[][], int map[]){
		/* this method is used internally by graphIsomorphism */
		int i,j,k,auxsize,flag,p,q,r,s,t,v;

		int ctr1, ctr2, ctr3, ctr4;

		int savelabel[][] = new int[n+1][n+1];
		int savemap[] = new int[n+1];
		int aux1[] = new int[n+1];
		int aux2[] = new int[n+1];
		int aux3[] = new int[n+1];
		int aux4[] = new int[4 * n+1];
		boolean found;
		aux4[1] = 0;
		ctr2 = 0;
		ctr3 = 0;
		ctr4 = 0;
		auxsize = 4 * n;
		//initial identity ordering
		for (i=1; i<=n; i++){
			map[i] = i;
		}
		//compute the code
		for (i=1; i<=n; i++){
			p = map[i];
			if (map[i] < 1 || n < map[i]) return false;

			for (j=1; j<=n; j++) {
				q = map[j];
				if (map[j] < 1 || n < map[j]) return false;

				if(adj[p][q] == 1){
					label[p][q] = 1;
				}else{
					label[p][q] = 0;
				}
			}
		}
		//save the current best ordering and code
		for (i=1; i<=n; i++) {
			for (j=1; j<=n; j++){
				savelabel[i][j] = label[i][j];
			}
			savemap[i] = map[i];
		}
		//begin backtrack search
		//consider all possible orderings and their codes
		ctr1 = 0;
		while (true) {
			//construct the integer vector by backtracking
			if (ctr1 == 0) {
				//process the complete vector
				ctr2 = 1;
				ctr4 = 0;
				ctr1 = 2;
			}else {
				//examine the stack
				while (true) {
					if (0 < aux1[ctr2]) {
						//take the first available one off the stack
						map[ctr2] = aux4[ctr4];
						ctr4--;
						aux1[ctr2]--;
						if (ctr2 != n) {
							ctr2++;
							ctr1 = 2;
						}else{
							ctr1 = 1;
						}
						break;
					}else {
						//there are no candidates for position ctr2
						ctr2--;
						if (ctr2 <= 0) {
							//repeat the examination of the stack
							ctr1 = 3;
							break;
						}
					}
				}
			}
			//if the backtrack routine has returned a complete candidate
			//ordering, then compute the resulting code, and compare with
			//the current best and go back for the next backtrack search
			if (ctr1 == 1) {
				//compute the code
				for (i=1; i<=n; i++) {
					p = map[i];
					if (map[i] < 1 || n < map[i]) return false;

					for (j=1; j<=n; j++) {
						q = map[j];
						if (map[j] < 1 || n < map[j]) return false;

						if (adj[p][q] != 0 ){
							label[i][j] = 1;
						}else{
							label[i][j] = 0;
						}
					}
				}
				//compare savelabel and code
				flag = 0;
				for (j=1; j<=n; j++) {
					for (i=1; i<=n; i++){
						if (savelabel[i][j] < label[i][j]) {
							flag = - 1;
							break;
						}
						else if (label[i][j] < savelabel[i][j]) {
							flag = 1;
							break;
						}
					}
					if (flag != 0) break;
				}
				ctr3++;
				if (flag == -1) {
					for (i=1; i<=n; i++) {
						for (j=1; j<=n; j++){
							savelabel[i][j] = label[i][j];
						}
						savemap[i] = map[i];
					}
				}
			}else if (ctr1 == 2) {
				//finds candidates for a maximal graph code ordering
				if (ctr2 < 1 || n < ctr2) return false;
				aux1[ctr2] = 0;
				found = false;
				if (1 < ctr2) {
					//compute the graph code for this node ordering
					for (i=1; i<=n; i++) {
						if (i <= ctr2-1) {
							p = map[i];
							if (map[i] < 1 || n < map[i]) return false;
						}else{
							p = 0;
						}
						for (j=1; j<=n; j++) {
							if (j <= ctr2-1) {
								q = map[j];
								if (map[j] < 1 || n < map[j]) return false;
							}else{
								q = 0;
							}
							if (adj[p][q] != 0){
								label[i][j] = 1;
							}else{
								label[i][j] = 0;
							}
						}
					}
					//compares the two graph codes
					flag = 0;
					for (j=1; j<=ctr2-1; j++) {
						for (i=1; i<=ctr2-1; i++) {
							if (savelabel[i][j] < label[i][j]) {
								flag = - 1;
								break;
							}else if (label[i][j] < savelabel[i][j]) {
								flag = + 1;
								break;
							}
						}
						if (flag != 0) break;
					}
					ctr3++;
					if (flag == 1) {
						aux1[ctr2] = 0;
						found = true;
					}
				}
				if (!found) {
					//list of nodes that have not been used
					t = n + 1 - ctr2;
					//find the number of unused items in the permutation
					v = ctr2 - 1 + t;
					if ( ctr2 - 1 < 0 ){
						return false;
					}else if (ctr2-1 == 0){
						for (i=1; i<=v; i++){
							aux2[i] = i;
						}
					}else if (t < 0){
						return false;
					}else if (t == 0){
						//do nothing
					}else{
						k = 0;
						for (i=1; i<=v; i++){
							r = 0;
							for (j=1; j<=ctr2-1; j++){
								if (map[j] == i) {
									r = j;
									break;
								}
							}
							if (r == 0) {
								k++;
								if (t < k) return false;
								aux2[k] = i;
							}
						}
					}
					aux1[ctr2] = 0;
					for (i=1; i<=ctr2-1; i++) {
						p = map[i];
						for (j=1; j<=t; j++) {
							q = aux2[j];
							if (adj[p][q] != 0 || adj[q][p] != 0) {
								aux1[ctr2]++;
								ctr4++;
								if (auxsize < ctr4) return false;
								aux4[ctr4] = q;
							}
						}
						if (0 < aux1[ctr2]) {
							found = true;
							break;
						}
					}
					if (!found){
						//no free nodes are connected to used nodes
						//take the free nodes with at least one neighbor
						s = 0;
						for (i=1; i<=t; i++) {
							p = aux2[i];
							aux3[i] = 0;
							for (j=1; j<=t; j++) {
								q = aux2[j];
								if (p != q){
									if (aux3[i] < adj[p][q]) aux3[i] = adj[p][q];
								}
							}
							if (s < aux3[i]) s = aux3[i];
						}
						aux1[ctr2] = 0;
						for (i=1; i<=t; i++){
							if (aux3[i] == s){
								aux1[ctr2]++;
								ctr4++;
								if (auxsize < ctr4) return false;
								aux4[ctr4] = aux2[i];
							}
						}
					}
				}
			}else{
				//all possibilities have been examined
				break;
			}
		}
		//set the best ordering and code
		for (i=1; i<=n; i++) {
			for (j=1; j<=n; j++){
				label[i][j] = savelabel[i][j];
			}
			map[i] = savemap[i];
		}
		return true;
	}



	public static void heapsort(int n, int x[], boolean ascending){
		/* sort array elements x[1], x[2],..., x[n] in the order of
		* increasing (ascending=true) or decreasing (ascending=false)
		*/
		int elm,h,i,index,k,temp;
		if (n <= 1) return;
		//initially nodes n/2 to 1 are leaves in the heap
		for (i=n/2; i>=1; i--) {
			elm = x[i];

			index = i;
			while (true) {
				k = 2 * index;
				if (n < k) break;
				if (k + 1 <= n) {
					if (ascending) {
						if (x[k] < x[k+1]) k++;
					}else {
						if (x[k+1] < x[k]) k++;
					}
				}
				if (ascending) {
					if (x[k] <= elm) break;
				}else {
					if (elm <= x[k]) break;
				}
				x[index] = x[k];
				index = k;
			}
			x[index] = elm;
		}
		//swap x[1] with x[n]
		temp = x[1];
		x[1] = x[n];
		x[n] = temp;
		//repeat delete the root from the heap
		for (h=n-1; h>=2; h--) {
			//restore the heap structure of x[1] through x[h]
			for (i=h/2; i>=1; i--) {
				elm = x[i];
				index = i;
				while (true) {
					k = 2 * index;
					if (h < k) break;
					if (k + 1 <= h) {
						if (ascending) {
							if (x[k] < x[k+1]) k++;
						}else {
							if (x[k+1] < x[k]) k++;
						}
					}
					if (ascending) {
						if (x[k] <= elm) break;
					}else {
						if (elm <= x[k]) break;
					}
					x[index] = x[k];
					index = k;
				}
				x[index] = elm;
			}
			//swap x[1] and x[h]
			temp = x[1];
			x[1] = x[h];
			x[h] = temp;
		}
	}
}
