/*The weighted undirected graph class in matrix representation
 *-check interface for notes.
*/

package graphADT;

import java.io.*;
import java.util.ArrayList;

public class wUGraphMatrix extends wGraphMatrix implements wUGraph
{

    public wUGraphMatrix()
    {
        super();
    }

    public wUGraphMatrix(wUGraphMatrix G) //copy constructor
    {
        super(G);
    }

    public wUGraphMatrix(Graph G) // promote constructor
    {
        int n = G.order();
        addVertices(n);

        for (int i=0; i<n; i++)
        {
            ArrayList<Integer> nbrs = G.neighbors(i);
            for (int j : nbrs)
            {
                super.addArc(i,j);
                super.addArc(j,i); // ensure undirected
            }
        }
    }

    public wUGraphMatrix(GraphAdjMatrix G) // specialized constructor
    {
        int n = G.order();
        addVertices(n);

        for (int i = 0; i < n-1; i++)
        {
            for (int j = i; j < n; j++)
            {
                if (G.adj[i][j] || G.adj[j][i]) // underlying graph 
                {
                  adjW[i][j] = new Weight<Integer>(1);
                  adjW[j][i] = new Weight<Integer>(1);
                }
            }
        }
    }

    public wUGraphMatrix(BufferedReader buffer) // input constructor
    {
        super(buffer);  
    }

    public void addArc(int i, int j) // force edge
    {
        assert(0 <= i && i < order);
        assert(0 <= j && j < order);
        adjW[i][j] = new Weight<Integer>(1);
        adjW[j][i] = new Weight<Integer>(1);
    }

    public void removeArc(int i, int j)
    {
        assert(isEdge(i,j));
        adjW[i][j] = null;
        adjW[j][i] = null;
    }
    
    public void addArc(int i, int j, Weight weight)
    {
        assert(0 <= i && i < order);
        assert(0 <= j && j < order);
        adjW[i][j] = weight;
        adjW[j][i] = weight;
    }

    public void setArcWeight(int i, int j, Weight weight)
    {
        assert(isEdge(i,j));
        adjW[i][j] = weight;
        adjW[j][i] = weight;
    }

    public int size()
    {
        return super.size()/2;						//extends the wGraph[Implementation]
    }

}
