/* wUGraph: the weighted undirected graph interface
 *
 * wUGraph wUG = new wUGraphMatrix(Buffer);
 *
 * and the use of this interface allows the algorithms class to deal with all forms of the
 * graph implementations. Girth(Graph g) will take in any graph and return the girth.
 * the wUgrpah is the only way to mix the uGraph and wGraph interfaces.
 *
 * please refer to the uGraph and wGraph interfaces for notes; wGraph for the Weight object.
 */

package graphADT;

public interface wUGraph extends uGraph, wGraph
{
    void addArc(int i, int j); 	//overridden to have the default weight
    //overridden to make the arc addition bi-directional

    void addArc(int i, int j, Weight<?> weight); //new method to allow a weighted edge to be added
    //overridden to make the arc addition bi-directional

    void setArcWeight(int i, int j, Weight<?> weight); //now biDirectional

    void removeArc(int i, int j);				//removes edge

}
