/* wGraph: the weighted graph interface
 *
 * Similarly to the graph interface this allows code like:
 *    wGraph wG = new wGraphMatrix(Buffer);
 * and the use of this interface allows the algorithms class to deal with all forms of the
 * graph implementations. Girth(Graph g) will take in any graph and return the girth.
 *
 * The current algorithms do not include specific weighted graph algorithms, but should
 * you wish to add them it can deal with all weighted graphs - similarly to how the
 * undirected graphs are handled.
 */

/*
 * The default implementation of the matrix and list use Integers
 *
 * the weight class allows for abstract weights; you could use doubles, floats,
 * even Enum types to label edges just be sure to alter the
 *     wGraph[Implementation](BufferedReader buffer) constructor to account for
 * your weight choice.
 */


package graphADT;

import java.util.*;

public interface wGraph extends Graph
{
    class Weight<X>
    {
        private X value;
        //public Weight() {} 
        public Weight(X arg)
        {
            value = arg;
        }
        public X getValue()
        {
            return value;
        }
        public void setValue(X arg)
        {
            value = arg;
        }
        public String toString()
        {
            return value.toString();
        }
    }

    // void addArc(int i, int j); 			//overridden to have the default weight
    void addArc(int i, int j, Weight weight); 	//new method to allow a weighted edge to be added

    void setArcWeight(int i, int j, Weight weight);	//assumes edge i-j exists; and replaces the weight of edge i-j

    Weight getArcWeight(int i, int j);

    ArrayList<Weight> neighborWeights(int i); 	
    // If you call neighbors(i) and neighborWeights(i) then the k-th element 
    // of both lists are correlated

}
