// The undirected graph in matrix form

package graphADT;

import java.util.ArrayList;

public class uGraphMatrix extends GraphAdjMatrix implements uGraph
{
    public uGraphMatrix()
    {
        super();
    }

    public uGraphMatrix(uGraphMatrix G)
    {
        super(G);
    }

    public uGraphMatrix(uGraph G) 		//conversion
    {
        super(G);
    }

    public uGraphMatrix(GraphAdjMatrix G)
    {
        super(G);
        int n = order();

        // create underlying graph by adding symmetric edges
        //
        for (int i = 0; i < n-1; i++)
        {
            for (int j = i+1; j < n; j++)
            {
                if (isArc(i,j))
                {
                    super.addArc(j,i);
                }
                else if (isArc(j,i))
                {
                    super.addArc(i,j);
                }
            }
        }
    }

    public uGraphMatrix(Graph G)	//conversion constructor
    {
        int n = G.order();
        addVertices(n);

        // create underlying graph by adding symmetric edges
        //
        for (int i=0; i<n; i++)
        {
            ArrayList<Integer> nbrs = G.neighbors(i);
            for (int j : nbrs)
            {
                super.addArc(i,j);
                super.addArc(j,i);
            }
        }
    }

    // redefine size for undirected graph
    //
    public int size()
    {
        return super.size()/2;
    }

    public void addArc(int i, int j)
    {
        assert(0 <= i && i < order());
        assert(0 <= j && j < order());
        adj[i][j] = true;
        adj[j][i] = true;
    }

    public void removeArc(int i, int j)
    {
        assert(0 <= i && i < order());
        assert(0 <= j && j < order());
        adj[i][j] = false;
        adj[j][i] = false;
    }

}
