// The undirected graph in lists form

package graphADT;

import java.util.ArrayList;
import java.io.*;

public class uGraphLists extends GraphAdjLists implements uGraph
{

    public uGraphLists()
    {
        super();
    }

    public uGraphLists(uGraphLists G)
    {
        super(G);
    }

    public uGraphLists(uGraph G) 	//conversion
    {
        super(G);
    }

    public uGraphLists(Graph G)  //conversion constructor
    {
        int n = G.order();
        addVertices(n);

        // create underlying graph by adding symmetric edges
        //
        for (int i=0; i<n; i++)
        {
            ArrayList<Integer> nbrs = G.neighbors(i);
            for (int j : nbrs)
            {
                super.addArc(i,j);
                super.addArc(j,i);
            }
        }
    }

    public uGraphLists(BufferedReader buffer)
    {
        super(buffer);
    }

    // redefine size for undirected graph
    //
    public int size()
    {
        return super.size()/2;
    }

    public void addArc(int i, int j)
    {
        assert(0 <= i && i < order());
        assert(0 <= j && j < order());
        if (!isArc(i,j)) (adj.get(i)).add(j);
        if (!isArc(j,i)) (adj.get(j)).add(i);
    }

    public void removeArc(int i, int j)
    {
        assert(0 <= i && i < order());
        assert(0 <= j && j < order());
        if (isArc(i,j)) (adj.get(i)).remove(new Integer(j));
        if (isArc(j,i)) (adj.get(j)).remove(new Integer(i));
    }

}
