/*Updates '07 - Graph is now an interface.
 *
 * The interface is implemented by the AdjLists and AdjMatrix classes.
 * This allows the user to write code such as:
 *      Graph g = new GraphAdjLists(Buffer);
 *
 * The two forms are now explicit, in the original class you had to choose.
 *
 * Please refer to uGraph the interface that extends this for further changes.
 */

package graphADT;

import java.util.ArrayList;
import java.io.BufferedReader; 

public interface Graph
{
    // Need default, copy and BufferedReader constructors
    // (commented since Java doesn't allow interface constructors!)
    //
    // public Graph(); 
    // public Graph(Graph G); 
    // public Graph(BufferedReader in);
 
    void addVertices(int i);		// Add some vertices.
    void removeVertex(int i);		// Remove vertex.

    void addArc(int i, int j);		// Add directed edge.
    void removeArc(int i, int j);	// Remove directed edge.

    void addEdge(int i, int j);		// Add undirected edge.
    void removeEdge(int i, int j);	// Remove undirected edge.


    // data structure queries
    //
    boolean isArc(int i, int j);	// Check for directed edges.

    boolean isEdge(int i, int j);	// Check for undirected edges.

    int degree(int i);			    // Number of neighbors.
    int inDegree(int i);		    // Number of incoming arcs.

    ArrayList<Integer> neighbors(int i); 	// List of (out-) neighbors.

    int order(); 		            // Number of vertices.
    int size(); 		            // Number of edges.

    // output (default same as representation)
    //
    String toString();
}
