// MinoruDirectShowTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include "OpenCvInterop.h"

#include "DShowVideoCapture.h"
#include "DShowUtil.h"

#include "global.h"

#include <iostream>
#include <opencv/highgui.h>



int main(int argc, char* argv[])
{
	using namespace DShowVidCap;

	try {	
		DShowVideoCapture* capture = new DShowVideoCapture();

		capture->init();

		bool cam_found = false;
		std::vector<CaptureDevice> devices = capture->get_capture_devices();
		for ( std::vector<CaptureDevice>::const_iterator i = devices.begin(), 
			end = devices.end();
			i != end;
			++i) 
		{
			/* NOTE: This does not work as intended as "Minoru 3D Webcam"
			   will always be present as a software driver device.
			   Connecting without actual Minoru will cause exception
			   during connect(), which is caught in this demo code. */
			if (i->get_friendly_name().compare("Minoru 3D Webcam") == 0) {
				std::cout << "Minoru 3D Webcam found." << std::endl;
				capture->set_capture_device(*i);
				cam_found = true;
			}
		}

		if (!cam_found) {
			std::cerr << "Minoru 3D Webcam not found!" << std::endl;
			capture->quit();
			return -1;
		}

		// Connects the filter graph.
		capture->connect();

		// These 2 called after connect.
		capture->open_camera_controls(); // call blocks.
		capture->open_format_controls(); // call blocks.

		std::cout << "Press ENTER to start capture." << std::endl;
		getchar();
		std::cout << "Starting capture..." << std::endl;
		capture->start_capture();

		std::cout << "Press ENTER to stop capture." << std::endl;
		getchar();

		/* Grabs a frame from the camera and saves. */
		unsigned char* image_data;
		long size;
		// Gets a new copy of the frame.
		capture->get_current_frame_copy(&image_data, &size);
		IplImage* image = BGR_to_IplImage(image_data, WIDTH_SINGLE_IMAGE * 2, HEIGHT_SINGLE_IMAGE);
		cvSaveImage("last_image_LR.png", image);
		IplImage* left = NULL;
		IplImage* right = NULL;
		split_image_half(image, &left, &right);
		cvSaveImage("last_image_L.png", left);
		cvSaveImage("last_image_R.png", right);
		
		delete[] image_data;
		cvReleaseImage(&image);
		cvReleaseImage(&left);
		cvReleaseImage(&right);

		capture->stop_capture();
		capture->quit();

		delete capture;

	} catch (std::exception e) {
		std::cout << "EXCEPTION: " << e.what() << std::endl;
		getchar();
	}

	return 0;
}

