#pragma once

#ifndef SAMPLE_GRABBER_CB_H__
#define SAMPLE_GRABBER_CB_H__

#include <dshow.h>
#include <qedit.h> // DirectShow Editing Services; link qedit.lib

namespace DShowVidCap {

class SampleGrabberCB : public ISampleGrabberCB {

private:
	unsigned long ref_count_;
	unsigned long image_count_;

public: /* Interface functions */
	SampleGrabberCB() ;
	~SampleGrabberCB() ;

	ULONG __stdcall AddRef() {
		return ++ref_count_;
	}

	ULONG __stdcall Release() {
		--ref_count_;
		if (ref_count_ <= 0) {
			// TODO free itself
		}
		return ref_count_;
	}

	// Will always do nothing and fail.
	HRESULT __stdcall QueryInterface(REFIID riid, void** ppvObject) {
		return E_NOINTERFACE;
	}

	HRESULT __stdcall BufferCB(double SampleTime, BYTE* pBuffer, long BufferLen) ;

	HRESULT __stdcall SampleCB(double SampleTime, IMediaSample* pSample) ;

public: /* extra functions */
	inline unsigned long get_image_count() { return image_count_; }



}; 

} // namespace DShowVidCap

#endif // ifndef