#include "SampleGrabberCB.h"

#include <iostream>
#include <iomanip>
#include <string>
#include <sstream>

#include <opencv/cv.h>
#include <opencv/highgui.h>

#include "global.h"

namespace DShowVidCap {

SampleGrabberCB::SampleGrabberCB() : ref_count_(0), image_count_(0) {

	//cvNamedWindow("Image");
}

SampleGrabberCB::~SampleGrabberCB() { 
	//cvDestroyWindow("Image");

	// TODO
}

HRESULT SampleGrabberCB::BufferCB(double SampleTime, BYTE* pBuffer, long BufferLen) {
	std::cout << "BufferCB" << std::endl;

	++image_count_;

	return E_FAIL; // TODO
}

HRESULT SampleGrabberCB::SampleCB(double SampleTime, IMediaSample* pSample) {
	HRESULT hr;
	
	std::cout << "SampleCB; time: " << SampleTime << std::endl;

	++image_count_;

	AM_MEDIA_TYPE* media_type;
	hr = pSample->GetMediaType(&media_type); // Does not support?!?!?!

	//if (hr == S_OK) {
	//	std::cout << "OK to get AM_MEDIA_TYPE." << std::endl;
	//}

	//if (hr != S_OK) {
	//	std::cout << "Failed to get AM_MEDIA_TYPE." << std::endl;
	//	return E_FAIL;
	//}

	//if (media_type->formattype != FORMAT_VideoInfo) {
	//	// TODO: cannot handle!
	//}
	//VIDEOINFOHEADER* video_info_header = reinterpret_cast<VIDEOINFOHEADER*>(media_type->pbFormat);
	
	int width = WIDTH_SINGLE_IMAGE * 2; //video_info_header->bmiHeader.biWidth;
	int height = HEIGHT_SINGLE_IMAGE; //video_info_header->bmiHeader.biHeight;

	IplImage* image = cvCreateImage(cvSize(width, height), IPL_DEPTH_8U, CHANNELS_PER_PIXEL);

	BYTE* image_data = NULL;

	pSample->GetPointer( (BYTE**) &(image_data));

	// WARNING: IplImage has line paddings, this will NOT work for some width settings.
	// See OpenCVInterop.cpp for method to copy memory with line padding.
	memcpy(image->imageData, image_data, pSample->GetActualDataLength());

	// Data is bottom to top scanlines, so flip them.
	cvFlip(image, image);

	//cvShowImage("Image", image);
	std::ostringstream s;
	s << "image" << std::setfill('0') << std::setw(4) << image_count_ << ".png";
	cvSaveImage(s.str().c_str(), image);
	cvReleaseImage(&image);

	return S_OK; // TODO
}

} // namespace DShowVidCap