#ifndef OPENCV_INTEROP_H__
#define OPENCV_INTEROP_H__

#include <opencv/cv.h>

namespace DShowVidCap {

// Constructs a new IplImage from raw data. The size of image_data must be exactly width * height * 3, in BGR layout. 
IplImage* BGR_to_IplImage(const unsigned char* image_data, int width, int height) ;

unsigned char** IplImage_to_BGR(const IplImage* in_image) ;

void split_image_half(const IplImage* in_image, IplImage** out_left, IplImage** out_right) ;

} // namespace DShowVidCap


#endif // OPENCV_INTEROP_H__