#include "OpenCVInterop.h"

#include "global.h"

namespace DShowVidCap {

IplImage* BGR_to_IplImage(const unsigned char* image_data, int width, int height) {
	IplImage* image = cvCreateImage(cvSize(width, height), IPL_DEPTH_8U, CHANNELS_PER_PIXEL);
	
	ptrdiff_t ipl_ptr = reinterpret_cast<ptrdiff_t>(image->imageData);
	ptrdiff_t data_ptr = reinterpret_cast<ptrdiff_t>(image_data) + (height-1) * width * CHANNELS_PER_PIXEL; // Start at the end, as IplImage is inverted
	for (int line = 0; line < height; ++line) {
		memcpy(reinterpret_cast<void*>(ipl_ptr), reinterpret_cast<void*>(data_ptr), width * CHANNELS_PER_PIXEL);
		ipl_ptr += image->widthStep;
		data_ptr -= width * CHANNELS_PER_PIXEL;
	}

	//cvFlip(image); // done above

	return image;
}

void split_image_half(const IplImage* in_image, IplImage** out_left, IplImage** out_right) {
	*out_left = cvCreateImage(cvSize(in_image->width / 2, in_image->height), in_image->depth, in_image->nChannels);
	*out_right = cvCreateImage(cvSize(in_image->width / 2, in_image->height), in_image->depth, in_image->nChannels);
	IplImage* temp_image = cvCloneImage(in_image);
	
	CvRect r;
	r.x = 0;
	r.y = 0;
	r.width = in_image->width / 2;
	r.height = in_image->height;
	cvSetImageROI(temp_image, r);

	cvCopy(temp_image, *out_left);
	r.x = in_image->width / 2;
	cvSetImageROI(temp_image, r);
	cvCopy(temp_image, *out_right);

	cvReleaseImage(&temp_image);
	cvResetImageROI(*out_left);
	cvResetImageROI(*out_right);
}

unsigned char** IplImage_to_BGR(const IplImage* in_image) {
	unsigned char* out_image_data = new unsigned char[ in_image->width * in_image->height * in_image->nChannels ];
	
	ptrdiff_t ipl_ptr = reinterpret_cast<ptrdiff_t>(in_image->imageData);
	ptrdiff_t data_ptr = reinterpret_cast<ptrdiff_t>(out_image_data) + (in_image->height-1) * in_image->width * in_image->nChannels; // Start at the end, as IplImage is inverted
	for (int line = 0; line < in_image->height; ++line) {
		memcpy(reinterpret_cast<void*>(data_ptr), reinterpret_cast<void*>(ipl_ptr), in_image->width * in_image->nChannels);
		ipl_ptr += in_image->widthStep;
		data_ptr -= in_image->width * in_image->nChannels;
	}

	return &out_image_data;
}

} // namespace DShowVidCap