#pragma once

#include <string>
#include <vector>

#include <atlbase.h>

#include <dshow.h> // DirectShow; link strmiids.lib
#include <qedit.h> // DirectShow Editing Services

#include "CaptureDevice.h"

namespace DShowVidCap {

class DShowVideoCapture {

private:
	//IMoniker* m_pMoniker ; // no longer needed

	IFilterGraph2* m_pGraph ; // IFilterGraph2 inherits both IFilterGraph and IGraphBuilder

	ICaptureGraphBuilder2* m_pCaptureGraphBuilder ;

	IBaseFilter* m_pCaptureFilter ;

	IMediaControl* m_pMediaControl ;
    IMediaEventEx* m_pMediaEvent ;

	IBaseFilter* m_pSampleGrabberFilter ;
	ISampleGrabber* m_pSampleGrabber ;

	IBaseFilter* m_pNullRendererFilter ;

	IAMStreamConfig* m_pStreamConfig ;

	IBaseFilter *pMux; // DEBUG

	ISampleGrabberCB* m_pSampleCB ;

	/* Constructors */
public:
	DShowVideoCapture() ;
	~DShowVideoCapture() ;

public:

	/* Initialise DirectShow. */
	void init() ;

	/* End DirectShow. */
	void quit() ;

	/* Gets a list of capture devices. */
	std::vector<CaptureDevice> get_capture_devices() ;

	void set_capture_device(CaptureDevice device) ;

	void set_media_type() ;

	void connect() ;

	void start_capture() ;
	void stop_capture() ;

	void open_format_controls() ;
	void open_camera_controls() ;

public:
	void get_current_frame_copy(BYTE** out_image_data, long* out_size) ;

private:
	// OBSOLETE
	IMoniker* find_device_by_FriendlyName(std::string friendly_name) ;
};

} // namespace DShowVidCap