#include "DShowVideoCapture.h"

#include <exception>

#include <dshow.h> // DirectShow; link strmiids.lib

#include "DShowUtil.h"

#include "SampleGrabberCB.h"

#include "global.h"

namespace DShowVidCap {

DShowVideoCapture::DShowVideoCapture() {
	//m_pMoniker = NULL;
	m_pGraph = NULL;
	m_pCaptureGraphBuilder = NULL;
	m_pCaptureFilter = NULL;
	m_pMediaControl = NULL;
    m_pMediaEvent = NULL;
	m_pSampleGrabberFilter = NULL;
	m_pSampleGrabber = NULL;
	m_pNullRendererFilter = NULL;
	m_pStreamConfig = NULL;

	HRESULT hr;
	hr = CoInitializeEx(NULL, COINIT_MULTITHREADED);
	if (!SUCCEEDED(hr)) {
		// try again, may be someone forgot to uninitialize
		CoUninitialize();
		hr = CoInitializeEx(NULL, COINIT_MULTITHREADED);
		if (!SUCCEEDED(hr)) // no idea, so we die instead of trying to continue
			throw std::exception("Cannot initialize COM.");
	}
}

DShowVideoCapture::~DShowVideoCapture() {
	CoUninitialize();
}

void DShowVideoCapture::init() {
	HRESULT hr;

	hr = CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC_SERVER, 
		IID_IFilterGraph2, reinterpret_cast<void**>(&m_pGraph));
	if (!SUCCEEDED(hr)) {
		throw std::exception("Cannot create graph.");
	}

	hr = CoCreateInstance(CLSID_CaptureGraphBuilder2, NULL, CLSCTX_INPROC_SERVER, IID_ICaptureGraphBuilder2, reinterpret_cast<void**>(&m_pCaptureGraphBuilder));
	if (!SUCCEEDED(hr)) {
		throw std::exception("Cannot create capture graph builder.");
	}

	// Set the graph used by the capture graph builder.
	hr = m_pCaptureGraphBuilder->SetFiltergraph(m_pGraph);
	if (!SUCCEEDED(hr)) {
		throw std::exception("Cannot setup capture graph builder with graph.");
	}

	// Setup the interfaces of the graph
	hr = m_pGraph->QueryInterface(IID_IMediaControl, reinterpret_cast<void**>(&m_pMediaControl));
	if (!SUCCEEDED(hr)) {
		// TODO
	}
	hr = m_pGraph->QueryInterface(IID_IMediaEventEx, reinterpret_cast<void**>(&m_pMediaEvent));
	if (!SUCCEEDED(hr)) {
		// TODO
	}

	// Create the sample grabber filter
	hr = CoCreateInstance(CLSID_SampleGrabber, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, reinterpret_cast<void**>(&m_pSampleGrabberFilter));
	if (!SUCCEEDED(hr)) {
		throw std::exception("Cannot create sample grabber.");
	}

	// Add sample grabber to graph
	hr = m_pGraph->AddFilter(m_pSampleGrabberFilter, L"Sample Grabber");
	if (!SUCCEEDED(hr)) {
		throw std::exception("Cannot add sample grabber.");
	}

	hr = m_pSampleGrabberFilter->QueryInterface(IID_ISampleGrabber, reinterpret_cast<void**>(&m_pSampleGrabber));
	if (!SUCCEEDED(hr)) {
		throw std::exception("bad"); // TODO
	}

	// Create and add null renderer to graph
	hr = CoCreateInstance(CLSID_NullRenderer, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, reinterpret_cast<void**>(&m_pNullRendererFilter));
	if (!SUCCEEDED(hr)) {
		throw std::exception("bad"); // TODO
	}
	hr = m_pGraph->AddFilter(m_pNullRendererFilter, L"Null Renderer");
	if (!SUCCEEDED(hr)) {
		throw std::exception("bad"); // TODO
	}

	// DEBUG
	//hr = m_pCaptureGraphBuilder->SetOutputFileName(
 //   &MEDIASUBTYPE_Avi,  // Specifies AVI for the target file.
 //   L"D:\\Example.avi", // File name.
 //   &pMux,              // Receives a pointer to the mux.
 //   NULL);              // (Optional) Receives a pointer to the file sink.



	m_pSampleCB = new SampleGrabberCB();


		
	set_media_type();
}

void DShowVideoCapture::quit() {
	m_pMediaControl->Stop();

	m_pGraph->Release();
}

std::vector<CaptureDevice> DShowVideoCapture::get_capture_devices() {
	std::vector<CaptureDevice> devices;

	HRESULT hr;
	CComPtr<ICreateDevEnum> pDevEnum;
	CComPtr<IEnumMoniker> pEnumMoniker;

	// Create the System Device Enumerator.
	hr = CoCreateInstance(CLSID_SystemDeviceEnum, NULL,
		CLSCTX_INPROC_SERVER, IID_ICreateDevEnum, 
		reinterpret_cast<void**>(&pDevEnum));
	if (SUCCEEDED(hr))
	{
		// Create an enumerator for the video capture category.
		hr = pDevEnum->CreateClassEnumerator(CLSID_VideoInputDeviceCategory,
			&pEnumMoniker, 0);
	} else {
		return devices;
	}

	CComPtr<IMoniker> pMoniker;

	while (pEnumMoniker->Next(1, &pMoniker, NULL) == S_OK) {
		CaptureDevice c(pMoniker);
		devices.push_back(c);
		pMoniker.Release(); // Ready smart pointer for next use.
	}

	return devices;
}

//IMoniker* DShowVideoCapture::find_device_by_FriendlyName(std::string friendly_name) {
//	HRESULT hr;
//
//	IEnumMoniker* pEnumMoniker = NULL;
//	pEnumMoniker = get_capture_devices();
//
//	if (!pEnumMoniker) {
//		return NULL;
//	}
//
//	IMoniker* pMoniker = NULL;
//	IMoniker* pMoniker_ret = NULL;
//	bool found = false;
//
//	// Fetch devices in the enum.
//	while (pEnumMoniker->Next(1, &pMoniker, NULL) == S_OK && !found) {
//		// pMoniker is valid here
//		IPropertyBag* pPropBag;
//		hr = pMoniker->BindToStorage(NULL, NULL, IID_IPropertyBag, reinterpret_cast<void**>(&pPropBag)); // Binds the IMoniker to the IPropertyBag 
//		if (FAILED(hr))
//		{
//			pMoniker->Release();
//			continue;  // Skip this one, maybe the next one will work.
//		} 
//
//		/* 
//		"FriendlyName"	The name of the device.
//		"Description"	A description of the device.
//		"DevicePath"	A unique string.
//		*/
//
//		VARIANT varName;
//		VariantInit(&varName);
//
//		hr = pPropBag->Read(L"FriendlyName", &varName, NULL);
//		if (SUCCEEDED(hr))
//		{
//			std::string name = from_variant(varName);
//			if (name.compare(friendly_name) == 0) {
//				found = true;
//				pMoniker_ret = pMoniker;
//			}
//		}
//		
//		VariantClear(&varName);
//		pPropBag->Release();
//		if (!found) {
//			pMoniker->Release();
//		}
//	}
//
//	return pMoniker_ret;
//}

void DShowVideoCapture::set_capture_device(CaptureDevice device) {
	HRESULT hr;
	hr = device.get_moniker()->BindToObject(NULL, NULL, IID_IBaseFilter, reinterpret_cast<void**>(&m_pCaptureFilter));
	if (SUCCEEDED(hr))
	{
		hr = m_pGraph->AddFilter(m_pCaptureFilter, L"Capture Filter");
	}
}

void DShowVideoCapture::set_media_type() {
	HRESULT hr;



	// Setup the media type that the sample grabber accepts
	AM_MEDIA_TYPE mt;
    ZeroMemory(&mt, sizeof(mt)); // NULL for any field means 'anything'
    mt.majortype = MEDIATYPE_Video;
    mt.subtype = MEDIASUBTYPE_RGB24;

    hr = m_pSampleGrabber->SetMediaType(&mt);
    if (FAILED(hr))
    {
        // TODO
    }

	
}

void DShowVideoCapture::connect() {

	// Set SampleGrabberCB
	m_pSampleGrabber->SetCallback(m_pSampleCB, 0); // 0 for SampleCB with IMediaSample, 1 for BufferCB with raw buffer
	m_pSampleGrabber->SetOneShot(false);
	m_pSampleGrabber->SetBufferSamples(true); // Enable sample buffering


	HRESULT hr;
	hr = m_pCaptureGraphBuilder->RenderStream(&PIN_CATEGORY_CAPTURE, NULL, m_pCaptureFilter, m_pSampleGrabberFilter, m_pNullRendererFilter);
	if (FAILED(hr)) {
		throw std::exception("Cannot connect graphs."); // TODO
	}

	hr = m_pCaptureGraphBuilder->FindInterface(
		&PIN_CATEGORY_CAPTURE, 
		0,    // Any media type.
		m_pCaptureFilter, // Pointer to the capture filter.
		IID_IAMStreamConfig, reinterpret_cast<void**>(&m_pStreamConfig));
	if (FAILED(hr)) {
		throw std::exception("Cannot get stream config.");
	}

	// Queries the supported media types of the capture device
	int count, size;
	m_pStreamConfig->GetNumberOfCapabilities(&count, &size);
	if (size == sizeof(VIDEO_STREAM_CONFIG_CAPS)) {

		bool found = false;
		for (int i = 0; i < count; ++i) {

			VIDEO_STREAM_CONFIG_CAPS scc;
			AM_MEDIA_TYPE* media_type; // GetStreamCaps will allocate.
			m_pStreamConfig->GetStreamCaps(i, &media_type, reinterpret_cast<BYTE*>(&scc));

			// search for the format
			if (scc.InputSize.cx == WIDTH_SINGLE_IMAGE * 2 && scc.InputSize.cy == HEIGHT_SINGLE_IMAGE) {
				VIDEOINFOHEADER* vih = reinterpret_cast<VIDEOINFOHEADER*>(media_type->pbFormat);
				if (vih->bmiHeader.biBitCount == BITS_PER_CHANNEL * CHANNELS_PER_PIXEL) {
					vih->AvgTimePerFrame = (REFERENCE_TIME) (1000000.0 / FRAMES_PER_SECOND); // set FPS
					m_pStreamConfig->SetFormat(media_type);
					found = true;
				}
			}

			MyDeleteMediaType(media_type);
		}
		if (!found) {
			throw std::exception("Cannot set resolution.");
		}
	}
}

void DShowVideoCapture::start_capture() {
	HRESULT hr;
	hr = m_pMediaControl->Run();
}

void DShowVideoCapture::stop_capture() {
	HRESULT hr;
	hr = m_pMediaControl->Stop();
}

void DShowVideoCapture::open_format_controls() {
	HRESULT hr;

	ISpecifyPropertyPages *pSpec;
    CAUUID cauuid;

	hr = m_pStreamConfig->QueryInterface(IID_ISpecifyPropertyPages, reinterpret_cast<void**>(&pSpec));
	if (SUCCEEDED(hr)) {
		hr = pSpec->GetPages(&cauuid);
		if (SUCCEEDED(hr) && cauuid.cElems > 0) {
			// do stuff
			//
			// Create property page. No parent window necccessary (blocks).
			hr = OleCreatePropertyFrame(NULL, 100, 100, NULL, 1,
                        (IUnknown **)&m_pStreamConfig, cauuid.cElems,
                        (GUID *)cauuid.pElems, 0, 0, NULL);

			// free mem
			CoTaskMemFree(cauuid.pElems);
		}
		pSpec->Release();
	}

}

void DShowVideoCapture::open_camera_controls() {
	HRESULT hr;

	ISpecifyPropertyPages *pSpec;
    CAUUID cauuid;

	hr = m_pCaptureFilter->QueryInterface(IID_ISpecifyPropertyPages, reinterpret_cast<void**>(&pSpec));
	if (SUCCEEDED(hr)) {
		hr = pSpec->GetPages(&cauuid);
		if (SUCCEEDED(hr) && cauuid.cElems > 0) {
			// do stuff
			//
			// Create property page. No parent window necccessary (blocks).
			hr = OleCreatePropertyFrame(NULL, 100, 100, NULL, 1,
                        (IUnknown **)&m_pCaptureFilter, cauuid.cElems,
                        (GUID *)cauuid.pElems, 0, 0, NULL);

			// free mem
			CoTaskMemFree(cauuid.pElems);
		}
		pSpec->Release();
	}

	/*----------- CODE BELOW FOR OLD VFW DEVICES (not Minoru) ----------*/

	//IAMVfwCaptureDialogs *pVfw = NULL;
	//hr = m_pCaptureGraphBuilder->QueryInterface(IID_IAMVfwCaptureDialogs, reinterpret_cast<void**>(&pVfw));
	////hr = m_pCaptureGraphBuilder->FindInterface(&PIN_CATEGORY_CAPTURE, &MEDIATYPE_Video, m_pCaptureFilter, IID_IAMVfwCaptureDialogs, reinterpret_cast<void**>(&pVfw));
	//if (SUCCEEDED(hr))
	//{
	//	hr = pVfw->HasDialog(VfwCaptureDialog_Format);
	//	// Check if the device supports this dialog box.
	//	if (hr == S_OK)
	//	{
	//		/*--------------- CREATE WINDOW --------------*/
	//		HWND       hWnd;
	//		WNDCLASSEX WndClsEx;

	//		// Create the application window
	//		WndClsEx.cbSize        = sizeof(WNDCLASSEX);
	//		WndClsEx.style         = CS_HREDRAW | CS_VREDRAW;
	//		WndClsEx.lpfnWndProc   = 0;
	//		WndClsEx.cbClsExtra    = 0;
	//		WndClsEx.cbWndExtra    = 0;
	//		WndClsEx.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
	//		WndClsEx.hCursor       = LoadCursor(NULL, IDC_ARROW);
	//		WndClsEx.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	//		WndClsEx.lpszMenuName  = NULL;
	//		WndClsEx.lpszClassName = L"BasicApp";
	//		WndClsEx.hInstance     = 0;
	//		WndClsEx.hIconSm       = LoadIcon(NULL, IDI_APPLICATION);

	//		// Register the application
	//		RegisterClassEx(&WndClsEx);

	//		// Create the window object
	//		hWnd = CreateWindow(L"BasicApp",
	//			L"ABCD",
	//			WS_OVERLAPPEDWINDOW,
	//			CW_USEDEFAULT,
	//			CW_USEDEFAULT,
	//			CW_USEDEFAULT,
	//			CW_USEDEFAULT,
	//			NULL,
	//			NULL,
	//			0,
	//			NULL);


	//		// Show the dialog box.
	//		hr = pVfw->ShowDialog(VfwCaptureDialog_Source, hWnd);
	//	}
	//}

}

void DShowVideoCapture::get_current_frame_copy(BYTE **out_image_data, long* out_size) {
	HRESULT hr;

	long size = 0;
	// Must call function twice! See documentation.
	hr = m_pSampleGrabber->GetCurrentBuffer(&size, NULL);
	BYTE* data = new BYTE[size];
	hr = m_pSampleGrabber->GetCurrentBuffer(&size, reinterpret_cast<long*>(data));
	*out_image_data = new BYTE[size];

	memcpy(*out_image_data, data, size);
	*out_size = size;

	delete[] data;
}

} // namespace DShowVidCap