#include "DShowUtil.h"

#include <ObjBase.h> // For CoTaskMemFree; link Ole32.lib
#include <comutil.h> // For bstr_t; link comsuppw.lib or comsuppwd.lib 

namespace DShowVidCap {

std::string from_variant(VARIANT& vt)
{
	bstr_t bs(vt);
	return std::string(static_cast<const char*>(bs));
}

void to_variant(const std::string& str, VARIANT& vt)
{
	bstr_t bs(str.c_str());
	reinterpret_cast<variant_t&>(vt) = bs;
}

// http://msdn.microsoft.com/en-us/library/ms783692%28VS.85%29.aspx
void MyFreeMediaType(AM_MEDIA_TYPE& mt)
{
    if (mt.cbFormat != 0)
    {
        CoTaskMemFree((PVOID)mt.pbFormat);
        mt.cbFormat = 0;
        mt.pbFormat = NULL;
    }
    if (mt.pUnk != NULL)
    {
        // Unecessary because pUnk should not be used, but safest.
        mt.pUnk->Release();
        mt.pUnk = NULL;
    }
}

// http://msdn.microsoft.com/en-us/library/ms783299%28VS.85%29.aspx
void MyDeleteMediaType(AM_MEDIA_TYPE *pmt)
{
    if (pmt != NULL)
    {
        MyFreeMediaType(*pmt); // See FreeMediaType for the implementation.
        CoTaskMemFree(pmt);
    }
}

std::string get_IMoniker_property_value(IMoniker* moniker, LPCOLESTR property) {
	std::string value; // init to empty string
	
	HRESULT hr;
	CComPtr<IPropertyBag> pPropBag;
	hr = moniker->BindToStorage(NULL, NULL, IID_IPropertyBag, reinterpret_cast<void**>(&pPropBag)); // Binds the IMoniker to the IPropertyBag 
	if (FAILED(hr))
	{
		return value; // empty string
	} 

	VARIANT varName;
	VariantInit(&varName);

	hr = pPropBag->Read(property, &varName, NULL);
	if (SUCCEEDED(hr))
	{
		value = from_variant(varName);
	}
	
	VariantClear(&varName); // redundant

	return value;
}

} // namespace DShowVidCap