#pragma once

#include <string>

#include <atlbase.h> // for CComPtr; link atlsd.lib for debug
// atlbase.h MUST come before dshow.h
#include <dshow.h>

namespace DShowVidCap {

class CaptureDevice {
private:
	std::string friendly_name_;
	std::string description_;
	std::string device_path_;

	CComPtr<IMoniker> moniker_;

private:
	CaptureDevice() ;

public:
	CaptureDevice(IMoniker* moniker) ;
	~CaptureDevice() ;

	std::string get_friendly_name() const ;
	std::string get_description() const ;
	std::string get_device_path() const ;

	CComPtr<IMoniker> get_moniker() const ;
};

} // namespace DShowVidCap