#include "CaptureDevice.h"

#include "DShowUtil.h"

namespace DShowVidCap {

CaptureDevice::CaptureDevice(IMoniker* moniker) {
	moniker_ = CComPtr<IMoniker>(moniker);

	this->friendly_name_ = get_IMoniker_property_value(moniker_, L"FriendlyName");
	this->description_ = get_IMoniker_property_value(moniker_, L"Description");
	this->device_path_ = get_IMoniker_property_value(moniker_, L"DevicePath");
}

CaptureDevice::~CaptureDevice() {
	// nothing needed
}

std::string CaptureDevice::get_friendly_name() const {
	return friendly_name_;
}

std::string CaptureDevice::get_description() const {
	return description_;
}

std::string CaptureDevice::get_device_path() const {
	return device_path_;
}

CComPtr<IMoniker> CaptureDevice::get_moniker() const {
	return moniker_; // copy
}

} // namespace DShowVidCap