package test;

import linearProgramming.*;
import java.io.IOException;
import lpsolve.LpSolveException;

public class Program {
	public static void printVars(LinearSpec ls) {
        for (Variable v : ls.variables) System.out.print(v.value + " ");
        System.out.println(ls.result);
    }

    public static void main(String[] args) throws IOException, LpSolveException, Exception {
        test1();
        java.io.DataInput in = new java.io.DataInputStream(System.in);
        in.readLine();
    }

    public static void test1() throws LpSolveException, Exception {
        LinearSpec ls = new LinearSpec();
        Variable x1 = ls.addVariable();
        Variable x2 = ls.addVariable();
        Constraint c1 = ls.addConstraint(1.0, x1, OperatorType.LE, 108);
        Constraint c2 = ls.addConstraint(1.0, x2, OperatorType.GE, 113);
        ls.setObjFunction(new double[] { 1, 1 }, new Variable[] { x1, x2 });
        ls.solve();
        printVars(ls);

        c2.remove();
        ls.solve();
        printVars(ls);

        c2 = ls.addConstraint(1.0, x2, OperatorType.GE, 113);
        ls.solve();
        printVars(ls);
    }

    public static void penaltyFunctionTest1() throws LpSolveException, Exception {
        LinearSpec ls = new LinearSpec();
        Variable var = ls.addVariable();

        ls.addPenaltyFunction(
    		var,
            new double[] { 1, 2, 3 },
            new double[] { -2, -1, 1, 2 });
        ls.solve();
        ls.save("lse2.txt");
        System.out.print("result=" + ls.result);
        System.out.print("\tvar=" + var.value);
        System.out.println("\tobj=" + ls.objectiveValue);

        for (double x = 0; x < 5; x += 0.5) {
        	var.setMax(x);
            var.setMin(x);
            ls.solve();
            System.out.print("result=" + ls.result);
            System.out.print("\tvar=" + var.value);
            System.out.println("\tobj=" + ls.objectiveValue);
            for (Variable v : ls.variables)
            	System.out.print(v + "=" + v.value+"\t");
            System.out.println();
        }
    }
}
