package linearProgramming;

/**
 * A summand of the objective function.
 */
public class Summand {

	double coeff;
	Variable var;

	/**
	 * Gets the summmand's coefficient.
	 * 
	 * @return the summand's coefficient
	 */
	public double getCoeff() {
		return coeff;
	}

	/**
	 * Sets the summmand's coefficient.
	 * 
	 * @param value	coefficient
	 */
	public void setCoeff(double value) throws Exception {
		coeff = value;
	}

	/**
	 * Gets the summand's variable.
	 * 
	 * @return the summand's variable
	 */
	public Variable getVar() {
		return var;
	}

	/**
	 * Sets the summand's variable.
	 * 
	 * @param value	variable
	 */
	public void setVar(Variable value) throws Exception {
		var = value;
	}

	Summand(double coeff, Variable var) {
		this.coeff = coeff;
		this.var = var;
	}

	/**
	 * Removes the summand from the objective function.
	 */
	public void remove() throws Exception {}
}
