package linearProgramming;

import java.util.*;

import lpsolve.LpSolveException;

/**
 * Penalty function.
 */
public class PenaltyFunction {

	LinearSpec ls;
	final Variable var;
	final double[] xs;
	final double[] gs;

	List<Constraint> constraints = new ArrayList<Constraint>();
	List<Summand> objFunctionSummands = new ArrayList<Summand>();

	PenaltyFunction(LinearSpec ls, Variable var, double[] xs, double[] gs) throws Exception {
		if (var.ls != ls)
			throw new Exception("The variable must belong to the same linear specification as the penalty function.");
		if(xs.length + 1 != gs.length)
			throw new Exception("The number of sampling points must be exactly one less than the number of gradients.");
		for(int i = 1; i < gs.length; i++)
			if(gs[i - 1] > gs[i]) throw new Exception("Penalty function must be concave.");

		this.var = var;
		this.xs = xs;
		this.gs = gs;

		constraints.add(ls.addConstraint(1.0, var,
				OperatorType.EQ, xs[0], -gs[0], gs[1]));

		for (int i = 1; i < gs.length - 1; i++) {
			Variable dPos = ls.addVariable();
			constraints.add(ls.addConstraint(1.0, var, -1.0, dPos,
					OperatorType.LE, xs[i]));
			objFunctionSummands.add(ls.addObjFunctionSummand(gs[i + 1] - gs[i], dPos));
		}
	}

	/**
	 * Removes all constraints and summands from the penalty function.
	 */
	public void remove() throws Exception {
		for (Constraint c : constraints) c.remove();
		for (Summand s : objFunctionSummands) s.remove();
	}
}
