package test1;

import java.awt.*;
import javax.swing.*;
import linearProgramming.*;
import lpsolve.*;
import alm.*;

public class Program extends JPanel {
	ALMEngine le = new ALMEngine();
	LayoutSpec ls = new LayoutSpec();
	
	JButton button1;
	JButton button2;
	JButton button3;
	
	public Program() throws Exception {
		setLayout(le);
		
		button1 = new JButton();
		button2 = new JButton();
		button3 = new JButton();
        // 
        // button1
        // 
        button1.setName("button1");
        button1.setText("button1");
        // 
        // button2
        // 
        button2.setName("button2");
        button2.setText("button2");
        // 
        // button3
        // 
        button3.setName("button3");
        button3.setText("button3");
        
        add(button1);
        add(button2);
        add(button3);
        setLayoutSpec();
	}
	
	public void setLayoutSpec() throws Exception {
        XTab x1 = ls.addXTab();
        YTab y1 = ls.addYTab();

        ls.addArea(ls.left, ls.top, x1, y1, button1);
        ls.addArea(x1, ls.top, ls.right, y1, button2);
        ls.addArea(ls.left, y1, ls.right, ls.bottom, button3);

        // give the two columns the same width and the two rows the same height
        ls.addConstraint(2, x1, -1, ls.right, OperatorType.EQ, 0);
        ls.addConstraint(2, y1, -1, ls.bottom, OperatorType.EQ, 0);

        le.layoutSpec = ls;
    }
	
	public static void main(String[] args) throws Exception {
		JFrame frame = new JFrame("Test1");
		frame.setSize(292, 266);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.getContentPane().add(new Program());
		frame.setVisible(true);
	}
}