package tableTest;

import javax.swing.*;
import alm.*;

public class Program extends JPanel {
	ALMEngine le = new ALMEngine();
	LayoutSpec ls = new LayoutSpec();
	
	public Program() throws Exception {
		setLayout(le);

        Column c1 = ls.addColumn(ls.left, ls.right);
        Row r1 = ls.addRow(ls.top, null);
        Row r3 = ls.addRow(null, ls.bottom);
        r1.setNext(r3);
        Row r2 = ls.addRow();
        r2.insertAfter(r1);

        JButton b1 = new JButton();
        b1.setText("A1");
        Area a1 = ls.addArea(r1, c1, b1);
        a1.setHAlignment(HorizontalAlignment.LEFT);
        a1.setVAlignment(VerticalAlignment.TOP);

        JButton b2 = new JButton();
        b2.setText("A2");
        Area a2 = ls.addArea(r2, c1, b2);
        a2.setHAlignment(HorizontalAlignment.CENTER);
        a2.setVAlignment(VerticalAlignment.CENTER);

        JButton b3 = new JButton();
        b3.setText("A3");
        Area a3 = ls.addArea(r3, c1, b3);
        a3.setHAlignment(HorizontalAlignment.RIGHT);
        a3.setVAlignment(VerticalAlignment.BOTTOM);

        //a2.Remove();
        //r2.Remove();

        r2.hasSameHeightAs(r1);
        r3.hasSameHeightAs(r1);

        le.layoutSpec = ls;
        
        add(b1);
        add(b2);
        add(b3);
	}
	
	public static void main(String[] args) throws Exception {
		JFrame frame = new JFrame("TableTest");
		frame.setSize(300,300);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.getContentPane().add(new Program());
		frame.setVisible(true);
	}
}
