package randomLayout;

import java.util.Random;
import java.util.List;
import java.util.ArrayList;
import java.awt.*;
import javax.swing.*;
import linearProgramming.*;
import lpsolve.LpSolveException;
import alm.*;

public class Program extends JPanel {
	ALMEngine le = new ALMEngine();
	LayoutSpec ls = new LayoutSpec();
	
	JButton b;
	
	public Program() throws Exception {
		setLayout(le);
		le.layoutSpec = generate(100, 0);
	}
	
	LayoutSpec generate(int n_areas, int n_constraints) throws Exception {
        Random rnd = new Random();
        LayoutSpec l = new LayoutSpec();
        l.addArea(l.left, l.top, l.right, l.bottom, null, new Dimension(0, 0));
        while (l.areas.size() < n_areas) {
            Area a = (Area)l.areas.toArray()[rnd.nextInt(l.areas.size())];
            a.remove();
            if (rnd.nextDouble() < 0.5) {
                XTab x = l.addXTab();
                l.addArea(a.getLeft(), a.getTop(), x, a.getBottom(), null, new Dimension(0, 0));
                l.addArea(x, a.getTop(), a.getRight(), a.getBottom(), null, new Dimension(0, 0));
            }
            else {
                YTab y = l.addYTab();
                l.addArea(a.getLeft(), a.getTop(), a.getRight(), y, null, new Dimension(0, 0));
                l.addArea(a.getLeft(), y, a.getRight(), a.getBottom(), null, new Dimension(0, 0));
            }
        }

        for (Area a : l.areas) {
            b = new JButton();
            b.setText(""+(l.areas.indexOf(a) + 1));
            add(b);
            a.setContent(b);
            a.setPrefContentSize(new Dimension(16 + rnd.nextInt(80), 16 + rnd.nextInt(80)));
            //a.ExpandRigidity = new SizeF((float)rnd.NextDouble(), (float)rnd.NextDouble());
            //a.ShrinkRigidity = new SizeF((float)rnd.NextDouble(), (float)rnd.NextDouble());

            //a.MinContentSize = new Dimension(rnd.Next(8 + 800 / n_areas), rnd.Next(8 + 600 / n_areas));
            //if (rnd.NextDouble() < 0.05)
            //{
            //    a.MaximumSize = new Dimension(
            //        a.MinimumSize.Width + rnd.Next(800),
            //        a.MinimumSize.Height + rnd.Next(600));
            //}
        }

        for (int i = 0; i < n_constraints; i++) {
            int length = 1 + rnd.nextInt(4);
            Summand[] summands = new Summand[length];
            List<Variable> vars = new ArrayList<Variable>();
            for (int k = 0; k < length; k++) {
                summands[k].setCoeff(0.5 - rnd.nextDouble());
                Variable v;
                do {
                    v = (Variable)l.variables.toArray()[rnd.nextInt(l.variables.size())];
                } while (vars.contains(v));
                summands[k].setVar(v);
                vars.add(v);
            }
            l.addConstraint(summands,
                    ((rnd.nextInt(2) == 0) ? OperatorType.EQ :
                        (rnd.nextInt(2) == 0) ? OperatorType.GE : OperatorType.LE),
                    0.5 - rnd.nextDouble(), rnd.nextDouble(), rnd.nextDouble());
        }
        return l;
    }
	
	public static void main(String[] args) throws Exception {
		JFrame frame = new JFrame("RandomLayout");
		frame.setSize(292, 266);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.getContentPane().add(new Program());
		frame.setVisible(true);
	}
}