/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import lpsolve.AbortListener;
import lpsolve.LogListener;
import lpsolve.LpSolve;
import lpsolve.LpSolveException;
import lpsolve.MsgListener;
import lpsolve.VersionInfo;

public class LpSolveTest
extends TestCase {
    static /* synthetic */ Class class$LpSolveTest;

    public LpSolveTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)LpSolveTest.suite());
    }

    public static TestSuite suite() {
        return new TestSuite(class$LpSolveTest == null ? (class$LpSolveTest = LpSolveTest.class$("LpSolveTest")) : class$LpSolveTest);
    }

    public void testVersion() throws Exception {
        VersionInfo versionInfo = LpSolve.lpSolveVersion();
        LpSolveTest.assertEquals((int)5, (int)versionInfo.getMajorversion());
        LpSolveTest.assertEquals((int)5, (int)versionInfo.getMinorversion());
        LpSolveTest.assertEquals((int)0, (int)versionInfo.getRelease());
    }

    public void testMakeLp() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        LpSolveTest.assertTrue((lpSolve.getLp() > 0L ? 1 : 0) != 0);
        lpSolve.deleteLp();
        LpSolveTest.assertEquals((long)0L, (long)lpSolve.getLp());
    }

    public void testTwoProblems() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        LpSolve lpSolve2 = LpSolve.makeLp(5, 6);
        LpSolveTest.assertTrue((lpSolve.getLp() > 0L ? 1 : 0) != 0);
        LpSolveTest.assertTrue((lpSolve2.getLp() > 0L ? 1 : 0) != 0);
        LpSolveTest.assertTrue((lpSolve.getLp() != lpSolve2.getLp() ? 1 : 0) != 0);
        LpSolveTest.assertEquals((int)3, (int)lpSolve.getNrows());
        LpSolveTest.assertEquals((int)5, (int)lpSolve2.getNrows());
        LpSolveTest.assertEquals((int)4, (int)lpSolve.getNcolumns());
        LpSolveTest.assertEquals((int)6, (int)lpSolve2.getNcolumns());
        LpSolveTest.assertEquals((int)3, (int)lpSolve.getNorigRows());
        LpSolveTest.assertEquals((int)5, (int)lpSolve2.getNorigRows());
        LpSolveTest.assertEquals((int)4, (int)lpSolve.getNorigColumns());
        LpSolveTest.assertEquals((int)6, (int)lpSolve2.getNorigColumns());
        lpSolve.deleteLp();
        lpSolve2.deleteLp();
        LpSolveTest.assertEquals((long)0L, (long)lpSolve.getLp());
        LpSolveTest.assertEquals((long)0L, (long)lpSolve2.getLp());
    }

    private LpSolve setupProblem() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.strSetObjFn("2 3 -2 3");
        return lpSolve;
    }

    private void verifyProblem(LpSolve lpSolve) throws Exception {
        LpSolveTest.assertEquals((int)2, (int)lpSolve.getNrows());
        LpSolveTest.assertEquals((int)4, (int)lpSolve.getNcolumns());
        double[] dArray = lpSolve.getPtrRow(0);
        LpSolveTest.assertEquals((int)5, (int)dArray.length);
        LpSolveTest.assertEquals((double)2.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)3.0, (double)dArray[2], (double)1.0E-8);
        LpSolveTest.assertEquals((double)-2.0, (double)dArray[3], (double)1.0E-8);
        LpSolveTest.assertEquals((double)3.0, (double)dArray[4], (double)1.0E-8);
    }

    public void testReadWriteLp() throws Exception {
        String string = "testmodel.lp";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        LpSolve lpSolve = this.setupProblem();
        lpSolve.writeLp(string);
        LpSolveTest.assertTrue((boolean)file.exists());
        lpSolve.deleteLp();
        lpSolve = LpSolve.readLp(string, 4, "Testmodel LP");
        this.verifyProblem(lpSolve);
        lpSolve.deleteLp();
        if (file.exists()) {
            file.delete();
        }
    }

    public void testReadWriteLpNative() throws Exception {
        String string = "model_\u00e4\u00fc\u00f6.lp";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        LpSolve lpSolve = this.setupProblem();
        lpSolve.writeLp(string);
        LpSolveTest.assertTrue((boolean)file.exists());
        lpSolve.deleteLp();
        lpSolve = LpSolve.readLp(string, 4, "Testmodel LP");
        this.verifyProblem(lpSolve);
        lpSolve.deleteLp();
        if (file.exists()) {
            file.delete();
        }
    }

    public void testReadWriteMps() throws Exception {
        String string = "testmodel.mps";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        LpSolve lpSolve = this.setupProblem();
        lpSolve.writeMps(string);
        LpSolveTest.assertTrue((boolean)file.exists());
        lpSolve.deleteLp();
        lpSolve = LpSolve.readMps(string, 4);
        this.verifyProblem(lpSolve);
        lpSolve.deleteLp();
        if (file.exists()) {
            file.delete();
        }
    }

    public void testReadWriteFreeMps() throws Exception {
        String string = "testmodel.fmps";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        LpSolve lpSolve = this.setupProblem();
        lpSolve.writeFreeMps(string);
        LpSolveTest.assertTrue((boolean)file.exists());
        lpSolve.deleteLp();
        lpSolve = LpSolve.readFreeMps(string, 4);
        this.verifyProblem(lpSolve);
        lpSolve.deleteLp();
        if (file.exists()) {
            file.delete();
        }
    }

    private void readWriteXLI(String string) throws Exception {
        String string2 = "testmodel_" + string + ".txt";
        File file = new File(string2);
        if (file.exists()) {
            file.delete();
        }
        String string3 = "xli_" + string;
        LpSolve lpSolve = this.setupProblem();
        lpSolve.setXLI(string3);
        lpSolve.writeXLI(string2, null, false);
        LpSolveTest.assertTrue((boolean)file.exists());
        lpSolve.deleteLp();
        lpSolve = LpSolve.readXLI(string3, string2, null, null, 4);
        this.verifyProblem(lpSolve);
        lpSolve.deleteLp();
        if (file.exists()) {
            file.delete();
        }
    }

    public void testReadWriteXLI_CPLEX() throws Exception {
        this.readWriteXLI("CPLEX");
    }

    public void testReadWriteXLI_LINDO() throws Exception {
        this.readWriteXLI("LINDO");
    }

    public void testSetXLI_Unknown() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 0);
        try {
            lpSolve.setXLI("Unknown");
            LpSolveTest.fail((String)"Setting a nonexistent XLI should throw an exception");
        }
        catch (LpSolveException lpSolveException) {
            System.out.println("setXLI failed as expected");
        }
        lpSolve.deleteLp();
    }

    public void testHasXLI() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 0);
        LpSolveTest.assertFalse((boolean)lpSolve.isNativeXLI());
        LpSolveTest.assertFalse((boolean)lpSolve.hasXLI());
        lpSolve.setXLI("xli_CPLEX");
        LpSolveTest.assertTrue((boolean)lpSolve.hasXLI());
        lpSolve.deleteLp();
    }

    public void testAddColumnex() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 0);
        LpSolveTest.assertEquals((int)0, (int)lpSolve.getNcolumns());
        double[] dArray = new double[]{1.5, 3.5};
        int[] nArray = new int[]{1, 3};
        lpSolve.addColumnex(2, dArray, nArray);
        LpSolveTest.assertEquals((int)1, (int)lpSolve.getNcolumns());
        double[] dArray2 = lpSolve.getPtrColumn(1);
        LpSolveTest.assertEquals((double)0.0, (double)dArray2[0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)1.5, (double)dArray2[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)0.0, (double)dArray2[2], (double)1.0E-8);
        LpSolveTest.assertEquals((double)3.5, (double)dArray2[3], (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testSetColumn() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 0);
        lpSolve.strAddColumn("1 2 3 4");
        LpSolveTest.assertEquals((int)1, (int)lpSolve.getNcolumns());
        double[] dArray = lpSolve.getPtrColumn(1);
        LpSolveTest.assertEquals((double)1.0, (double)dArray[0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)2.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)3.0, (double)dArray[2], (double)1.0E-8);
        LpSolveTest.assertEquals((double)4.0, (double)dArray[3], (double)1.0E-8);
        double[] dArray2 = new double[]{5.0, 6.0, 7.0, 8.0};
        lpSolve.setColumn(1, dArray2);
        dArray = lpSolve.getPtrColumn(1);
        LpSolveTest.assertEquals((double)5.0, (double)dArray[0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)6.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)7.0, (double)dArray[2], (double)1.0E-8);
        LpSolveTest.assertEquals((double)8.0, (double)dArray[3], (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testSetColumnex() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 0);
        lpSolve.strAddColumn("1 2 3 4");
        LpSolveTest.assertEquals((int)1, (int)lpSolve.getNcolumns());
        double[] dArray = lpSolve.getPtrColumn(1);
        LpSolveTest.assertEquals((double)1.0, (double)dArray[0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)2.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)3.0, (double)dArray[2], (double)1.0E-8);
        LpSolveTest.assertEquals((double)4.0, (double)dArray[3], (double)1.0E-8);
        double[] dArray2 = new double[]{6.0, 8.0};
        int[] nArray = new int[]{1, 3};
        lpSolve.setColumnex(1, 2, dArray2, nArray);
        dArray = lpSolve.getPtrColumn(1);
        LpSolveTest.assertEquals((double)0.0, (double)dArray[0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)6.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)0.0, (double)dArray[2], (double)1.0E-8);
        LpSolveTest.assertEquals((double)8.0, (double)dArray[3], (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testSetRow() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("1 2 3 4", 1, 4.0);
        double[] dArray = lpSolve.getPtrRow(1);
        LpSolveTest.assertEquals((int)5, (int)dArray.length);
        LpSolveTest.assertEquals((double)1.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)2.0, (double)dArray[2], (double)1.0E-8);
        double[] dArray2 = new double[]{0.0, 5.0, 6.0, 7.0, 8.0};
        lpSolve.setRow(1, dArray2);
        dArray = lpSolve.getPtrRow(1);
        LpSolveTest.assertEquals((double)5.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)6.0, (double)dArray[2], (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testSetRowex() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("1 2 3 4", 1, 4.0);
        double[] dArray = lpSolve.getPtrRow(1);
        LpSolveTest.assertEquals((int)5, (int)dArray.length);
        LpSolveTest.assertEquals((double)1.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)2.0, (double)dArray[2], (double)1.0E-8);
        LpSolveTest.assertEquals((double)3.0, (double)dArray[3], (double)1.0E-8);
        LpSolveTest.assertEquals((double)4.0, (double)dArray[4], (double)1.0E-8);
        double[] dArray2 = new double[]{5.0, 7.0};
        int[] nArray = new int[]{1, 3};
        lpSolve.setRowex(1, 2, dArray2, nArray);
        dArray = lpSolve.getPtrRow(1);
        LpSolveTest.assertEquals((double)5.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)0.0, (double)dArray[2], (double)1.0E-8);
        LpSolveTest.assertEquals((double)7.0, (double)dArray[3], (double)1.0E-8);
        LpSolveTest.assertEquals((double)0.0, (double)dArray[4], (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testGetSetBasiscrash() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 0);
        LpSolveTest.assertEquals((int)0, (int)lpSolve.getBasiscrash());
        lpSolve.setBasiscrash(2);
        LpSolveTest.assertEquals((int)2, (int)lpSolve.getBasiscrash());
        lpSolve.deleteLp();
    }

    public void testGetSetBbDepthlimit() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 0);
        LpSolveTest.assertEquals((int)-50, (int)lpSolve.getBbDepthlimit());
        lpSolve.setBbDepthlimit(10);
        LpSolveTest.assertEquals((int)10, (int)lpSolve.getBbDepthlimit());
        lpSolve.deleteLp();
    }

    public void testGetSetSimplextype() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 0);
        LpSolveTest.assertEquals((int)6, (int)lpSolve.getSimplextype());
        LpSolveTest.assertEquals((int)6, (int)lpSolve.getSimplextype());
        lpSolve.setSimplextype(9);
        LpSolveTest.assertEquals((int)9, (int)lpSolve.getSimplextype());
        lpSolve.deleteLp();
    }

    public void testSetPreferdual() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 0);
        lpSolve.setPreferdual(true);
        LpSolveTest.assertEquals((int)10, (int)lpSolve.getSimplextype());
        lpSolve.setPreferdual(false);
        LpSolveTest.assertEquals((int)5, (int)lpSolve.getSimplextype());
        lpSolve.deleteLp();
    }

    public void testGetSetScalelimit() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 0);
        LpSolveTest.assertEquals((double)5.0, (double)lpSolve.getScalelimit(), (double)1.0E-8);
        lpSolve.setScalelimit(10.0);
        LpSolveTest.assertEquals((double)10.0, (double)lpSolve.getScalelimit(), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testGetStatustext() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 0);
        lpSolve.setVerbose(3);
        int n = lpSolve.solve();
        String string = lpSolve.getStatustext(n);
        LpSolveTest.assertNotNull((Object)string);
        LpSolveTest.assertTrue((string.length() > 0 ? 1 : 0) != 0);
        lpSolve.deleteLp();
    }

    public void testSetBFP() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 0);
        LpSolveTest.assertTrue((boolean)lpSolve.hasBFP());
        LpSolveTest.assertTrue((boolean)lpSolve.isNativeBFP());
        lpSolve.setBFP("bfp_LUSOL");
        LpSolveTest.assertTrue((boolean)lpSolve.hasBFP());
        LpSolveTest.assertFalse((boolean)lpSolve.isNativeBFP());
        lpSolve.deleteLp();
    }

    public void testSetBFPException() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 0);
        try {
            lpSolve.setBFP("nonexistent");
            LpSolveTest.fail((String)"Setting a nonexistent BFP should throw an exception");
        }
        catch (LpSolveException lpSolveException) {
            System.out.println("setBFP failed as expected");
        }
        lpSolve.deleteLp();
    }

    public void testSetUnbounded() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 2);
        LpSolveTest.assertFalse((boolean)lpSolve.isUnbounded(1));
        lpSolve.setUnbounded(1);
        LpSolveTest.assertTrue((boolean)lpSolve.isUnbounded(1));
        lpSolve.deleteLp();
    }

    public void testIsNegative() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 2);
        LpSolveTest.assertFalse((boolean)lpSolve.isNegative(1));
        lpSolve.setLowbo(1, -10.0);
        lpSolve.setUpbo(1, -1.0);
        LpSolveTest.assertTrue((boolean)lpSolve.isNegative(1));
        lpSolve.deleteLp();
    }

    public void testGetSetUpbo() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 2);
        LpSolveTest.assertEquals((double)1.0E30, (double)lpSolve.getUpbo(1), (double)1.0E-8);
        lpSolve.setUpbo(1, 1234.0);
        LpSolveTest.assertEquals((double)1234.0, (double)lpSolve.getUpbo(1), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testGetSetLowbo() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 2);
        LpSolveTest.assertEquals((double)0.0, (double)lpSolve.getLowbo(1), (double)1.0E-8);
        lpSolve.setLowbo(1, -1234.0);
        LpSolveTest.assertEquals((double)-1234.0, (double)lpSolve.getLowbo(1), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testSetBounds() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 2);
        lpSolve.setBounds(1, -1234.0, 5555.0);
        LpSolveTest.assertEquals((double)-1234.0, (double)lpSolve.getLowbo(1), (double)1.0E-8);
        LpSolveTest.assertEquals((double)5555.0, (double)lpSolve.getUpbo(1), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testWriteDebugdump() throws Exception {
        String string = "debugdump.txt";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.strSetObjFn("2 3 -2 3");
        lpSolve.setVerbose(3);
        lpSolve.solve();
        lpSolve.printDebugdump(file.getAbsolutePath());
        lpSolve.deleteLp();
        LpSolveTest.assertTrue((boolean)file.exists());
        if (file.exists()) {
            file.delete();
        }
    }

    public void testSetOutputfile() throws Exception {
        String string = "print_file.txt";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.setOutputfile(file.getAbsolutePath());
        lpSolve.setOutputfile(null);
        lpSolve.deleteLp();
        LpSolveTest.assertTrue((boolean)file.exists());
        if (file.exists()) {
            file.delete();
        }
    }

    public void testPrintSolution() throws Exception {
        String string = "print_solution.txt";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.setOutputfile(file.getAbsolutePath());
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.strSetObjFn("2 3 -2 3");
        lpSolve.printLp();
        lpSolve.setVerbose(3);
        lpSolve.solve();
        lpSolve.printSolution(1);
        lpSolve.printConstraints(1);
        lpSolve.printObjective();
        lpSolve.printDuals();
        lpSolve.printScales();
        lpSolve.setOutputfile(null);
        lpSolve.deleteLp();
        LpSolveTest.assertTrue((boolean)file.exists());
        if (file.exists()) {
            file.delete();
        }
    }

    public void testPrintTableau() throws Exception {
        String string = "print_tableau.txt";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.setOutputfile(file.getAbsolutePath());
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.strSetObjFn("2 3 -2 3");
        lpSolve.setVerbose(3);
        lpSolve.solve();
        lpSolve.printTableau();
        lpSolve.setOutputfile(null);
        lpSolve.deleteLp();
        LpSolveTest.assertTrue((boolean)file.exists());
        LpSolveTest.assertTrue((boolean)file.canRead());
        if (file.exists()) {
            file.delete();
        }
    }

    public void testPrintStr() throws Exception {
        String string = "print_str.txt";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.setOutputfile(file.getAbsolutePath());
        lpSolve.printStr("Test\u00fc\u00f6\u00e4\u00df");
        lpSolve.printStr(null);
        lpSolve.setOutputfile(null);
        lpSolve.deleteLp();
        LpSolveTest.assertTrue((boolean)file.exists());
        LpSolveTest.assertTrue((file.length() == 8L ? 1 : 0) != 0);
        if (file.exists()) {
            file.delete();
        }
    }

    public void testSetObj() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.strSetObjFn("2 3 -2 3");
        double[] dArray = lpSolve.getPtrRow(0);
        LpSolveTest.assertEquals((int)5, (int)dArray.length);
        LpSolveTest.assertEquals((double)2.0, (double)dArray[1], (double)1.0E-8);
        lpSolve.setObj(1, 6.6);
        dArray = lpSolve.getPtrRow(0);
        LpSolveTest.assertEquals((int)5, (int)dArray.length);
        LpSolveTest.assertEquals((double)6.6, (double)dArray[1], (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testGetRow() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        int n = 1 + lpSolve.getNcolumns();
        double[] dArray = new double[n];
        lpSolve.getRow(1, dArray);
        double[] dArray2 = lpSolve.getPtrRow(1);
        LpSolveTest.assertEquals((int)n, (int)dArray2.length);
        LpSolveTest.assertEquals((double)3.0, (double)dArray[1], (double)1.0E-8);
        for (int i = 0; i < n; ++i) {
            LpSolveTest.assertEquals((double)dArray[i], (double)dArray2[i], (double)1.0E-8);
        }
        lpSolve.deleteLp();
    }

    public void testGetRowex() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strSetObjFn("2 3 -2 3");
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 0 1", 2, 3.0);
        int n = lpSolve.getNcolumns();
        double[] dArray = new double[n];
        int[] nArray = new int[n];
        int n2 = lpSolve.getRowex(1, dArray, nArray);
        LpSolveTest.assertEquals((int)4, (int)n2);
        LpSolveTest.assertEquals((double)3.0, (double)dArray[0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)2.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)2.0, (double)dArray[2], (double)1.0E-8);
        LpSolveTest.assertEquals((double)1.0, (double)dArray[3], (double)1.0E-8);
        LpSolveTest.assertEquals((int)1, (int)nArray[0]);
        LpSolveTest.assertEquals((int)2, (int)nArray[1]);
        LpSolveTest.assertEquals((int)3, (int)nArray[2]);
        LpSolveTest.assertEquals((int)4, (int)nArray[3]);
        n2 = lpSolve.getRowex(2, dArray, nArray);
        LpSolveTest.assertEquals((int)2, (int)n2);
        LpSolveTest.assertEquals((double)4.0, (double)dArray[0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)1.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((int)2, (int)nArray[0]);
        LpSolveTest.assertEquals((int)4, (int)nArray[1]);
        lpSolve.deleteLp();
    }

    public void testGetColumn() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strSetObjFn("2 3 -2 3");
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        int n = 1 + lpSolve.getNrows();
        double[] dArray = new double[n];
        lpSolve.getColumn(1, dArray);
        double[] dArray2 = lpSolve.getPtrColumn(1);
        LpSolveTest.assertEquals((int)n, (int)dArray2.length);
        LpSolveTest.assertEquals((double)2.0, (double)dArray[0], (double)1.0E-8);
        for (int i = 0; i < n; ++i) {
            LpSolveTest.assertEquals((double)dArray[i], (double)dArray2[i], (double)1.0E-8);
        }
        lpSolve.deleteLp();
    }

    public void testGetColumnex() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strSetObjFn("2 3 -2 3");
        lpSolve.strAddConstraint("0 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("3 4 0 1", 2, 3.0);
        int n = 1 + lpSolve.getNrows();
        double[] dArray = new double[n];
        int[] nArray = new int[n];
        int n2 = lpSolve.getColumnex(1, dArray, nArray);
        LpSolveTest.assertEquals((int)2, (int)n2);
        LpSolveTest.assertEquals((double)2.0, (double)dArray[0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)3.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((int)0, (int)nArray[0]);
        LpSolveTest.assertEquals((int)2, (int)nArray[1]);
        n2 = lpSolve.getColumnex(2, dArray, nArray);
        LpSolveTest.assertEquals((int)3, (int)n2);
        LpSolveTest.assertEquals((double)3.0, (double)dArray[0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)2.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)4.0, (double)dArray[2], (double)1.0E-8);
        LpSolveTest.assertEquals((int)0, (int)nArray[0]);
        LpSolveTest.assertEquals((int)1, (int)nArray[1]);
        LpSolveTest.assertEquals((int)2, (int)nArray[2]);
        lpSolve.deleteLp();
    }

    public void testMinimMaxim() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertFalse((boolean)lpSolve.isMaxim());
        lpSolve.setMaxim();
        LpSolveTest.assertTrue((boolean)lpSolve.isMaxim());
        lpSolve.setMinim();
        LpSolveTest.assertFalse((boolean)lpSolve.isMaxim());
        lpSolve.setMaxim();
        LpSolveTest.assertTrue((boolean)lpSolve.isMaxim());
        lpSolve.setSense(false);
        LpSolveTest.assertFalse((boolean)lpSolve.isMaxim());
        lpSolve.deleteLp();
    }

    public void testAddDelConstraint() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((int)0, (int)lpSolve.getNrows());
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        LpSolveTest.assertEquals((int)1, (int)lpSolve.getNrows());
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
        lpSolve.addConstraint(dArray, 2, 5.0);
        LpSolveTest.assertEquals((int)2, (int)lpSolve.getNrows());
        lpSolve.delConstraint(1);
        LpSolveTest.assertEquals((int)1, (int)lpSolve.getNrows());
        lpSolve.delConstraint(1);
        LpSolveTest.assertEquals((int)0, (int)lpSolve.getNrows());
        lpSolve.deleteLp();
    }

    public void testAddConstraintex() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((int)0, (int)lpSolve.getNrows());
        double[] dArray = new double[]{1.5, 3.5};
        int[] nArray = new int[]{1, 3};
        lpSolve.addConstraintex(2, dArray, nArray, 2, 10.0);
        LpSolveTest.assertEquals((int)1, (int)lpSolve.getNrows());
        double[] dArray2 = lpSolve.getPtrRow(1);
        LpSolveTest.assertEquals((int)5, (int)dArray2.length);
        LpSolveTest.assertEquals((double)1.5, (double)dArray2[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)0.0, (double)dArray2[2], (double)1.0E-8);
        LpSolveTest.assertEquals((double)3.5, (double)dArray2[3], (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testGetNonzeros() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((int)0, (int)lpSolve.getNonzeros());
        double[] dArray = new double[]{1.5, 3.5};
        int[] nArray = new int[]{1, 3};
        lpSolve.addConstraintex(2, dArray, nArray, 2, 10.0);
        LpSolveTest.assertEquals((int)2, (int)lpSolve.getNonzeros());
        lpSolve.deleteLp();
    }

    public void testSetObjFn() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strSetObjFn("1 -2 3 -4");
        double[] dArray = lpSolve.getPtrRow(0);
        LpSolveTest.assertEquals((int)5, (int)dArray.length);
        LpSolveTest.assertEquals((double)1.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)-2.0, (double)dArray[2], (double)1.0E-8);
        LpSolveTest.assertEquals((double)3.0, (double)dArray[3], (double)1.0E-8);
        LpSolveTest.assertEquals((double)-4.0, (double)dArray[4], (double)1.0E-8);
        lpSolve.setObjFn(new double[]{0.0, 9.0, -8.0, 7.0, -6.0});
        dArray = lpSolve.getPtrRow(0);
        LpSolveTest.assertEquals((double)9.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)-8.0, (double)dArray[2], (double)1.0E-8);
        LpSolveTest.assertEquals((double)7.0, (double)dArray[3], (double)1.0E-8);
        LpSolveTest.assertEquals((double)-6.0, (double)dArray[4], (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testSetObjFnex() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        double[] dArray = new double[]{1.5, 3.5};
        int[] nArray = new int[]{2, 4};
        lpSolve.setObjFnex(2, dArray, nArray);
        double[] dArray2 = lpSolve.getPtrRow(0);
        LpSolveTest.assertEquals((int)5, (int)dArray2.length);
        LpSolveTest.assertEquals((double)1.5, (double)dArray2[2], (double)1.0E-8);
        LpSolveTest.assertEquals((double)0.0, (double)dArray2[3], (double)1.0E-8);
        LpSolveTest.assertEquals((double)3.5, (double)dArray2[4], (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testAddDelColumn() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 0);
        LpSolveTest.assertEquals((int)0, (int)lpSolve.getNcolumns());
        lpSolve.strAddColumn("3 2 2 1");
        LpSolveTest.assertEquals((int)1, (int)lpSolve.getNcolumns());
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
        lpSolve.addColumn(dArray);
        LpSolveTest.assertEquals((int)2, (int)lpSolve.getNcolumns());
        lpSolve.delColumn(1);
        LpSolveTest.assertEquals((int)1, (int)lpSolve.getNcolumns());
        lpSolve.delColumn(1);
        LpSolveTest.assertEquals((int)0, (int)lpSolve.getNcolumns());
        lpSolve.deleteLp();
    }

    public void testDelColumnWithException() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 0);
        try {
            lpSolve.delColumn(1);
            LpSolveTest.fail((String)"delColumn with nonexistent col shouold throw an Exception");
        }
        catch (LpSolveException lpSolveException) {
            System.out.println("delColumn failed as expected");
        }
        lpSolve.deleteLp();
    }

    public void testColumnInLp() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 0);
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
        double[] dArray2 = new double[]{0.0, 5.0, 6.0, 7.0, 8.0};
        lpSolve.addColumn(dArray);
        lpSolve.addColumn(dArray2);
        LpSolveTest.assertEquals((int)2, (int)lpSolve.getNcolumns());
        LpSolveTest.assertEquals((int)1, (int)lpSolve.columnInLp(dArray));
        LpSolveTest.assertEquals((int)2, (int)lpSolve.columnInLp(dArray2));
        dArray[1] = 100.6;
        LpSolveTest.assertEquals((int)0, (int)lpSolve.columnInLp(dArray));
        LpSolveTest.assertEquals((int)2, (int)lpSolve.columnInLp(dArray2));
        lpSolve.deleteLp();
    }

    public void testGetSetLpName() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        LpSolveTest.assertEquals((String)"", (String)lpSolve.getLpName());
        lpSolve.setLpName("test");
        LpSolveTest.assertEquals((String)"test", (String)lpSolve.getLpName());
        lpSolve.setLpName(null);
        LpSolveTest.assertEquals((String)"", (String)lpSolve.getLpName());
        lpSolve.deleteLp();
    }

    public void testGetSetRowName() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(1, 0);
        LpSolveTest.assertEquals((String)"R1", (String)lpSolve.getRowName(1));
        lpSolve.setRowName(1, "test");
        LpSolveTest.assertEquals((String)"test", (String)lpSolve.getRowName(1));
        LpSolveTest.assertEquals((String)"test", (String)lpSolve.getOrigrowName(1));
        lpSolve.deleteLp();
    }

    public void testGetSetColName() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 1);
        LpSolveTest.assertEquals((String)"C1", (String)lpSolve.getColName(1));
        lpSolve.setColName(1, "test");
        LpSolveTest.assertEquals((String)"test", (String)lpSolve.getColName(1));
        LpSolveTest.assertEquals((String)"test", (String)lpSolve.getOrigcolName(1));
        lpSolve.deleteLp();
    }

    public void testGetSetMat() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        LpSolveTest.assertEquals((double)0.0, (double)lpSolve.getMat(1, 1), (double)1.0E-8);
        lpSolve.setMat(1, 1, 0.5);
        LpSolveTest.assertEquals((double)0.5, (double)lpSolve.getMat(1, 1), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testGetSetVerbose() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        LpSolveTest.assertEquals((int)4, (int)lpSolve.getVerbose());
        lpSolve.setVerbose(5);
        LpSolveTest.assertEquals((int)5, (int)lpSolve.getVerbose());
        lpSolve.setVerbose(2);
        LpSolveTest.assertEquals((int)2, (int)lpSolve.getVerbose());
        lpSolve.deleteLp();
    }

    public void testGetSetTimeout() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        LpSolveTest.assertEquals((long)0L, (long)lpSolve.getTimeout());
        lpSolve.setTimeout(1234L);
        LpSolveTest.assertEquals((long)1234L, (long)lpSolve.getTimeout());
        lpSolve.deleteLp();
    }

    public void testGetSetPrintSol() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        LpSolveTest.assertEquals((int)0, (int)lpSolve.getPrintSol());
        lpSolve.setPrintSol(1);
        LpSolveTest.assertEquals((int)1, (int)lpSolve.getPrintSol());
        lpSolve.deleteLp();
    }

    public void testGetSetDebug() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        LpSolveTest.assertEquals((boolean)false, (boolean)lpSolve.isDebug());
        lpSolve.setDebug(true);
        LpSolveTest.assertEquals((boolean)true, (boolean)lpSolve.isDebug());
        lpSolve.deleteLp();
    }

    public void testGetSetTrace() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        LpSolveTest.assertEquals((boolean)false, (boolean)lpSolve.isTrace());
        lpSolve.setTrace(true);
        LpSolveTest.assertEquals((boolean)true, (boolean)lpSolve.isTrace());
        lpSolve.deleteLp();
    }

    public void testGetSetLagTrace() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        LpSolveTest.assertEquals((boolean)false, (boolean)lpSolve.isLagTrace());
        lpSolve.setLagTrace(true);
        LpSolveTest.assertEquals((boolean)true, (boolean)lpSolve.isLagTrace());
        lpSolve.deleteLp();
    }

    public void testSetAddRowmode() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        LpSolveTest.assertEquals((boolean)false, (boolean)lpSolve.isAddRowmode());
        LpSolveTest.assertEquals((boolean)false, (boolean)lpSolve.setAddRowmode(false));
        LpSolveTest.assertEquals((boolean)true, (boolean)lpSolve.setAddRowmode(true));
        LpSolveTest.assertEquals((boolean)true, (boolean)lpSolve.isAddRowmode());
        lpSolve.deleteLp();
    }

    public void testSetAddRowmode2() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.setAddRowmode(true);
        LpSolveTest.assertEquals((boolean)true, (boolean)lpSolve.isAddRowmode());
        double[] dArray = new double[]{0.0, 2.0, 3.0, -2.0, 3.0};
        lpSolve.setObjFn(dArray);
        double[] dArray2 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
        lpSolve.addConstraint(dArray2, 2, 5.0);
        lpSolve.setAddRowmode(false);
        dArray = lpSolve.getPtrRow(0);
        LpSolveTest.assertEquals((double)2.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)3.0, (double)dArray[2], (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testGetSetAntiDegen() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        lpSolve.setAntiDegen(64);
        LpSolveTest.assertEquals((boolean)true, (boolean)lpSolve.isAntiDegen(64));
        LpSolveTest.assertEquals((int)64, (int)lpSolve.getAntiDegen());
        lpSolve.deleteLp();
    }

    public void testGetSetPresolve() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        LpSolveTest.assertEquals((boolean)true, (boolean)lpSolve.isPresolve(0));
        lpSolve.setPresolve(3, 2);
        LpSolveTest.assertTrue((boolean)lpSolve.isPresolve(3));
        LpSolveTest.assertTrue((boolean)lpSolve.isPresolve(1));
        LpSolveTest.assertEquals((int)3, (int)lpSolve.getPresolve());
        lpSolve.deleteLp();
    }

    public void testGetPresolveloops() throws Exception {
        LpSolve lpSolve = this.setupProblem();
        lpSolve.setPresolve(3, 1);
        lpSolve.setVerbose(3);
        lpSolve.solve();
        LpSolveTest.assertEquals((int)1, (int)lpSolve.getPresolveloops());
        lpSolve.deleteLp();
    }

    public void testGetSetMaxpivot() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        LpSolveTest.assertEquals((int)250, (int)lpSolve.getMaxpivot());
        lpSolve.setMaxpivot(44);
        LpSolveTest.assertEquals((int)44, (int)lpSolve.getMaxpivot());
        lpSolve.deleteLp();
    }

    public void testGetSetBbRule() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        lpSolve.setBbRule(2);
        LpSolveTest.assertEquals((int)2, (int)lpSolve.getBbRule());
        lpSolve.deleteLp();
    }

    public void testGetSetObjBound() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        LpSolveTest.assertEquals((double)lpSolve.getInfinite(), (double)lpSolve.getObjBound(), (double)1.0E-8);
        lpSolve.setObjBound(1234.56);
        LpSolveTest.assertEquals((double)1234.56, (double)lpSolve.getObjBound(), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testGetSetFloorFirst() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        LpSolveTest.assertEquals((int)2, (int)lpSolve.getBbFloorfirst());
        lpSolve.setBbFloorfirst(0);
        LpSolveTest.assertEquals((int)0, (int)lpSolve.getBbFloorfirst());
        lpSolve.deleteLp();
    }

    public void testGetSetUseNames() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 4);
        LpSolveTest.assertEquals((boolean)true, (boolean)lpSolve.isUseNames(true));
        LpSolveTest.assertEquals((boolean)true, (boolean)lpSolve.isUseNames(false));
        lpSolve.setUseNames(true, false);
        lpSolve.setUseNames(false, false);
        LpSolveTest.assertEquals((boolean)false, (boolean)lpSolve.isUseNames(true));
        LpSolveTest.assertEquals((boolean)false, (boolean)lpSolve.isUseNames(false));
        lpSolve.deleteLp();
    }

    public void testGetObjectiveGetSolution() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.strSetObjFn("2 3 -2 3");
        lpSolve.setVerbose(3);
        int n = lpSolve.solve();
        LpSolveTest.assertEquals((int)0, (int)n);
        LpSolveTest.assertEquals((double)-4.0, (double)lpSolve.getObjective(), (double)1.0E-8);
        double[] dArray = lpSolve.getPtrPrimalSolution();
        int n2 = 1 + lpSolve.getNrows() + lpSolve.getNcolumns();
        LpSolveTest.assertEquals((int)n2, (int)dArray.length);
        int n3 = 1 + lpSolve.getNrows();
        LpSolveTest.assertEquals((double)0.0, (double)dArray[n3 + 0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)0.0, (double)dArray[n3 + 1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)2.0, (double)dArray[n3 + 2], (double)1.0E-8);
        LpSolveTest.assertEquals((double)0.0, (double)dArray[n3 + 3], (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testPrimalSolution() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        double[] dArray = new double[]{0.0, 2.0, 3.0, -2.0, 3.0};
        lpSolve.setObjFn(dArray);
        lpSolve.setVerbose(3);
        int n = lpSolve.solve();
        double[] dArray2 = lpSolve.getPtrPrimalSolution();
        double[] dArray3 = new double[7];
        lpSolve.getPrimalSolution(dArray3);
        Arrays.equals(dArray2, dArray3);
        lpSolve.deleteLp();
    }

    public void testVarDualresult() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.setObjFn(new double[]{0.0, 2.0, 3.0, -2.0, 3.0});
        lpSolve.setVerbose(3);
        lpSolve.solve();
        LpSolveTest.assertEquals((double)4.0, (double)lpSolve.getVarPrimalresult(1), (double)1.0E-8);
        LpSolveTest.assertEquals((double)-1.0, (double)lpSolve.getVarDualresult(1), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testGetPtrVariables() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.strSetObjFn("2 3 -2 3");
        lpSolve.setVerbose(3);
        lpSolve.solve();
        double[] dArray = lpSolve.getPtrVariables();
        LpSolveTest.assertEquals((int)lpSolve.getNcolumns(), (int)dArray.length);
        LpSolveTest.assertEquals((double)0.0, (double)dArray[0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)0.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)2.0, (double)dArray[2], (double)1.0E-8);
        LpSolveTest.assertEquals((double)0.0, (double)dArray[3], (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testGetVariables() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.strSetObjFn("2 3 -2 3");
        lpSolve.setVerbose(3);
        lpSolve.solve();
        double[] dArray = new double[4];
        lpSolve.getVariables(dArray);
        LpSolveTest.assertEquals((int)lpSolve.getNcolumns(), (int)dArray.length);
        LpSolveTest.assertEquals((double)0.0, (double)dArray[0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)0.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)2.0, (double)dArray[2], (double)1.0E-8);
        LpSolveTest.assertEquals((double)0.0, (double)dArray[3], (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testGetPtrConstraints() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.strSetObjFn("2 3 -2 3");
        lpSolve.setVerbose(3);
        lpSolve.solve();
        double[] dArray = lpSolve.getPtrConstraints();
        LpSolveTest.assertEquals((int)lpSolve.getNrows(), (int)dArray.length);
        LpSolveTest.assertEquals((double)4.0, (double)dArray[0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)6.0, (double)dArray[1], (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testGetConstraints() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.strSetObjFn("2 3 -2 3");
        lpSolve.setVerbose(3);
        lpSolve.solve();
        double[] dArray = new double[2];
        lpSolve.getConstraints(dArray);
        LpSolveTest.assertEquals((int)lpSolve.getNrows(), (int)dArray.length);
        LpSolveTest.assertEquals((double)4.0, (double)dArray[0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)6.0, (double)dArray[1], (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testRhVec() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        LpSolveTest.assertEquals((double)4.0, (double)lpSolve.getRh(1), (double)1.0E-8);
        LpSolveTest.assertEquals((double)3.0, (double)lpSolve.getRh(2), (double)1.0E-8);
        lpSolve.strSetRhVec("1 2");
        LpSolveTest.assertEquals((double)1.0, (double)lpSolve.getRh(1), (double)1.0E-8);
        LpSolveTest.assertEquals((double)2.0, (double)lpSolve.getRh(2), (double)1.0E-8);
        lpSolve.setRhVec(new double[]{0.0, 6.0, 7.5});
        LpSolveTest.assertEquals((double)6.0, (double)lpSolve.getRh(1), (double)1.0E-8);
        LpSolveTest.assertEquals((double)7.5, (double)lpSolve.getRh(2), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testRh() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        LpSolveTest.assertEquals((double)4.0, (double)lpSolve.getRh(1), (double)1.0E-8);
        LpSolveTest.assertEquals((double)3.0, (double)lpSolve.getRh(2), (double)1.0E-8);
        lpSolve.setRh(1, 1.0);
        lpSolve.setRh(2, 2.0);
        LpSolveTest.assertEquals((double)1.0, (double)lpSolve.getRh(1), (double)1.0E-8);
        LpSolveTest.assertEquals((double)2.0, (double)lpSolve.getRh(2), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testConstrType() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        LpSolveTest.assertEquals((int)1, (int)lpSolve.getConstrType(1));
        LpSolveTest.assertEquals((int)2, (int)lpSolve.getConstrType(2));
        lpSolve.setConstrType(1, 3);
        LpSolveTest.assertEquals((int)3, (int)lpSolve.getConstrType(1));
        lpSolve.deleteLp();
    }

    public void testRhRange() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.setRhRange(1, 20.5);
        LpSolveTest.assertEquals((double)20.5, (double)lpSolve.getRhRange(1), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testInt() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((boolean)false, (boolean)lpSolve.isInt(1));
        lpSolve.setInt(1, true);
        LpSolveTest.assertEquals((boolean)true, (boolean)lpSolve.isInt(1));
        lpSolve.setInt(1, false);
        LpSolveTest.assertEquals((boolean)false, (boolean)lpSolve.isInt(1));
        lpSolve.deleteLp();
    }

    public void testBinary() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((boolean)false, (boolean)lpSolve.isBinary(1));
        lpSolve.setBinary(1, true);
        LpSolveTest.assertEquals((boolean)true, (boolean)lpSolve.isBinary(1));
        lpSolve.setBinary(1, false);
        LpSolveTest.assertEquals((boolean)false, (boolean)lpSolve.isBinary(1));
        lpSolve.deleteLp();
    }

    public void testSemicont() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((boolean)false, (boolean)lpSolve.isSemicont(1));
        lpSolve.setSemicont(1, true);
        LpSolveTest.assertEquals((boolean)true, (boolean)lpSolve.isSemicont(1));
        lpSolve.setSemicont(1, false);
        LpSolveTest.assertEquals((boolean)false, (boolean)lpSolve.isSemicont(1));
        lpSolve.deleteLp();
    }

    public void testInfinite() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((double)1.0E30, (double)lpSolve.getInfinite(), (double)1.0E-8);
        LpSolveTest.assertTrue((boolean)lpSolve.isInfinite(lpSolve.getInfinite()));
        LpSolveTest.assertFalse((boolean)lpSolve.isInfinite(3.0E22));
        lpSolve.setInfinite(2.1E22);
        LpSolveTest.assertEquals((double)2.1E22, (double)lpSolve.getInfinite(), (double)1.0E-8);
        LpSolveTest.assertTrue((boolean)lpSolve.isInfinite(3.0E22));
        lpSolve.deleteLp();
    }

    public void testEpsint() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((double)1.0E-7, (double)lpSolve.getEpsint(), (double)1.0E-8);
        lpSolve.setEpsint(1.0E-4);
        LpSolveTest.assertEquals((double)1.0E-4, (double)lpSolve.getEpsint(), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testEpsb() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((double)1.0E-10, (double)lpSolve.getEpsb(), (double)1.0E-8);
        lpSolve.setEpsb(1.0E-4);
        LpSolveTest.assertEquals((double)1.0E-4, (double)lpSolve.getEpsb(), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testEpsd() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((double)1.0E-9, (double)lpSolve.getEpsd(), (double)1.0E-8);
        lpSolve.setEpsd(1.0E-4);
        LpSolveTest.assertEquals((double)1.0E-4, (double)lpSolve.getEpsd(), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testEpsel() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((double)1.0E-12, (double)lpSolve.getEpsel(), (double)1.0E-8);
        lpSolve.setEpsel(1.0E-4);
        LpSolveTest.assertEquals((double)1.0E-4, (double)lpSolve.getEpsel(), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testEpspivot() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((double)2.0E-7, (double)lpSolve.getEpspivot(), (double)1.0E-8);
        lpSolve.setEpspivot(1.0E-4);
        LpSolveTest.assertEquals((double)1.0E-4, (double)lpSolve.getEpspivot(), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testEpsperturb() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((double)1.0E-5, (double)lpSolve.getEpsperturb(), (double)1.0E-8);
        lpSolve.setEpsperturb(1.0E-4);
        LpSolveTest.assertEquals((double)1.0E-4, (double)lpSolve.getEpsperturb(), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testGetStatus() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(3, 0);
        LpSolveTest.assertEquals((int)-1, (int)lpSolve.getStatus());
        try {
            lpSolve.strAddColumn("1 2 3");
            LpSolveTest.fail((String)"this should throw an exception");
        }
        catch (LpSolveException lpSolveException) {
            System.out.println("strAddColumn failed as expected");
            LpSolveTest.assertEquals((int)-4, (int)lpSolve.getStatus());
        }
        lpSolve.deleteLp();
    }

    public void testMipGap() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.setMipGap(true, 1.0E-4);
        LpSolveTest.assertEquals((double)1.0E-4, (double)lpSolve.getMipGap(true), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testVarBranch() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.setVarBranch(1, 2);
        LpSolveTest.assertEquals((int)2, (int)lpSolve.getVarBranch(1));
        lpSolve.deleteLp();
    }

    public void testVarWeights() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 2);
        LpSolveTest.assertEquals((int)1, (int)lpSolve.getVarPriority(1));
        LpSolveTest.assertEquals((int)2, (int)lpSolve.getVarPriority(2));
        double[] dArray = new double[]{2.0, 1.0};
        lpSolve.setVarWeights(dArray);
        LpSolveTest.assertEquals((int)2, (int)lpSolve.getVarPriority(1));
        LpSolveTest.assertEquals((int)1, (int)lpSolve.getVarPriority(2));
        lpSolve.deleteLp();
    }

    public void testBreakAtFirst() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertFalse((boolean)lpSolve.isBreakAtFirst());
        lpSolve.setBreakAtFirst(true);
        LpSolveTest.assertTrue((boolean)lpSolve.isBreakAtFirst());
        lpSolve.deleteLp();
    }

    public void testBreakAtValue() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((double)(-lpSolve.getInfinite()), (double)lpSolve.getBreakAtValue(), (double)1.0E-8);
        lpSolve.setBreakAtValue(-1.2E22);
        LpSolveTest.assertEquals((double)-1.2E22, (double)lpSolve.getBreakAtValue(), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testScaling() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        int n = 33;
        lpSolve.setScaling(n);
        LpSolveTest.assertEquals((int)n, (int)lpSolve.getScaling());
        LpSolveTest.assertTrue((boolean)lpSolve.isScalemode(n));
        LpSolveTest.assertTrue((boolean)lpSolve.isScaletype(1));
        LpSolveTest.assertFalse((boolean)lpSolve.isIntegerscaling());
        lpSolve.setScaling(n | 0x80);
        LpSolveTest.assertTrue((boolean)lpSolve.isIntegerscaling());
        lpSolve.unscale();
        lpSolve.deleteLp();
    }

    public void testImprove() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((int)6, (int)lpSolve.getImprove());
        lpSolve.setImprove(8);
        LpSolveTest.assertEquals((int)8, (int)lpSolve.getImprove());
        lpSolve.deleteLp();
    }

    public void testPivoting() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((int)34, (int)lpSolve.getPivoting());
        LpSolveTest.assertTrue((boolean)lpSolve.isPivRule(2));
        LpSolveTest.assertTrue((boolean)lpSolve.isPivMode(32));
        int n = 7;
        lpSolve.setPivoting(n);
        LpSolveTest.assertEquals((int)n, (int)lpSolve.getPivoting());
        LpSolveTest.assertTrue((boolean)lpSolve.isPivRule(3));
        LpSolveTest.assertFalse((boolean)lpSolve.isPivRule(1));
        LpSolveTest.assertTrue((boolean)lpSolve.isPivMode(4));
        lpSolve.deleteLp();
    }

    public void testNegrange() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((double)-1000000.0, (double)lpSolve.getNegrange(), (double)1.0E-8);
        lpSolve.setNegrange(-1.234);
        LpSolveTest.assertEquals((double)-1.234, (double)lpSolve.getNegrange(), (double)1.0E-8);
        lpSolve.deleteLp();
    }

    public void testBasis() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.strSetObjFn("2 3 -2 3");
        lpSolve.setVerbose(3);
        lpSolve.solve();
        int[] nArray = new int[3];
        lpSolve.getBasis(nArray, false);
        int[] nArray2 = new int[]{0, -2, -3};
        lpSolve.setBasis(nArray2, false);
        lpSolve.getBasis(nArray, false);
        LpSolveTest.assertEquals((int)-2, (int)nArray[1]);
        LpSolveTest.assertEquals((int)-3, (int)nArray[2]);
        lpSolve.defaultBasis();
        lpSolve.getBasis(nArray, false);
        LpSolveTest.assertEquals((int)-1, (int)nArray[1]);
        LpSolveTest.assertEquals((int)-2, (int)nArray[2]);
        lpSolve.deleteLp();
    }

    public void testGetSensitivityRhs() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 2);
        lpSolve.strSetObjFn("1 1");
        lpSolve.strAddConstraint("2 4", 2, 10.0);
        lpSolve.setLowbo(1, 1.0);
        lpSolve.setVerbose(3);
        lpSolve.solve();
        int n = lpSolve.getNcolumns() + lpSolve.getNrows();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        lpSolve.getSensitivityRhs(dArray, dArray2, dArray3);
        double[][] dArray4 = lpSolve.getPtrSensitivityRhs();
        LpSolveTest.assertEquals((int)3, (int)dArray4.length);
        double[] dArray5 = dArray4[0];
        double[] dArray6 = dArray4[1];
        double[] dArray7 = dArray4[2];
        LpSolveTest.assertEquals((int)n, (int)dArray5.length);
        LpSolveTest.assertEquals((int)n, (int)dArray6.length);
        LpSolveTest.assertEquals((int)n, (int)dArray7.length);
        for (int i = 0; i < n; ++i) {
            LpSolveTest.assertEquals((double)dArray[i], (double)dArray5[i], (double)1.0E-8);
            LpSolveTest.assertEquals((double)dArray2[i], (double)dArray6[i], (double)1.0E-8);
            LpSolveTest.assertEquals((double)dArray3[i], (double)dArray7[i], (double)1.0E-8);
        }
        lpSolve.deleteLp();
    }

    public void testGetDualSolution() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 2);
        lpSolve.strSetObjFn("1 1");
        lpSolve.strAddConstraint("2 4", 2, 10.0);
        lpSolve.setLowbo(1, 1.0);
        lpSolve.setVerbose(3);
        lpSolve.solve();
        int n = 1 + lpSolve.getNcolumns() + lpSolve.getNrows();
        double[] dArray = new double[n];
        lpSolve.getDualSolution(dArray);
        double[] dArray2 = lpSolve.getPtrDualSolution();
        LpSolveTest.assertEquals((int)n, (int)dArray2.length);
        for (int i = 0; i < n; ++i) {
            LpSolveTest.assertEquals((double)dArray[i], (double)dArray2[i], (double)1.0E-8);
        }
        lpSolve.deleteLp();
    }

    public void testGetSensitivityObj() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 2);
        lpSolve.strSetObjFn("1 1");
        lpSolve.strAddConstraint("2 4", 2, 10.0);
        lpSolve.setLowbo(1, 1.0);
        lpSolve.setVerbose(3);
        lpSolve.solve();
        int n = lpSolve.getNcolumns();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        lpSolve.getSensitivityObj(dArray, dArray2);
        double[][] dArray3 = lpSolve.getPtrSensitivityObj();
        LpSolveTest.assertEquals((int)2, (int)dArray3.length);
        double[] dArray4 = dArray3[0];
        double[] dArray5 = dArray3[1];
        LpSolveTest.assertEquals((int)n, (int)dArray4.length);
        LpSolveTest.assertEquals((int)n, (int)dArray5.length);
        LpSolveTest.assertEquals((double)0.5, (double)dArray[0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)lpSolve.getInfinite(), (double)dArray2[0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)0.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)2.0, (double)dArray2[1], (double)1.0E-8);
        for (int i = 0; i < n; ++i) {
            LpSolveTest.assertEquals((double)dArray[i], (double)dArray4[i], (double)1.0E-8);
            LpSolveTest.assertEquals((double)dArray2[i], (double)dArray5[i], (double)1.0E-8);
        }
        lpSolve.deleteLp();
    }

    public void testGetSensitivityObjex() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 2);
        lpSolve.strSetObjFn("1 1");
        lpSolve.strAddConstraint("2 4", 2, 10.0);
        lpSolve.setLowbo(1, 1.0);
        lpSolve.setVerbose(3);
        lpSolve.solve();
        int n = lpSolve.getNcolumns();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        lpSolve.getSensitivityObjex(dArray, dArray2, dArray3, dArray4);
        double[][] dArray5 = lpSolve.getPtrSensitivityObjex();
        LpSolveTest.assertEquals((int)4, (int)dArray5.length);
        double[] dArray6 = dArray5[0];
        double[] dArray7 = dArray5[1];
        double[] dArray8 = dArray5[2];
        double[] dArray9 = dArray5[3];
        LpSolveTest.assertEquals((int)n, (int)dArray6.length);
        LpSolveTest.assertEquals((int)n, (int)dArray7.length);
        LpSolveTest.assertEquals((int)n, (int)dArray8.length);
        LpSolveTest.assertEquals((int)n, (int)dArray9.length);
        LpSolveTest.assertEquals((double)0.5, (double)dArray[0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)lpSolve.getInfinite(), (double)dArray2[0], (double)1.0E-8);
        LpSolveTest.assertEquals((double)0.0, (double)dArray[1], (double)1.0E-8);
        LpSolveTest.assertEquals((double)2.0, (double)dArray2[1], (double)1.0E-8);
        for (int i = 0; i < n; ++i) {
            LpSolveTest.assertEquals((double)dArray[i], (double)dArray6[i], (double)1.0E-8);
            LpSolveTest.assertEquals((double)dArray2[i], (double)dArray7[i], (double)1.0E-8);
            LpSolveTest.assertEquals((double)dArray3[i], (double)dArray8[i], (double)1.0E-8);
        }
        lpSolve.deleteLp();
    }

    public void testIsConstrType() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        LpSolveTest.assertTrue((boolean)lpSolve.isConstrType(1, 1));
        LpSolveTest.assertFalse((boolean)lpSolve.isConstrType(1, 3));
        LpSolveTest.assertFalse((boolean)lpSolve.isConstrType(1, 2));
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        LpSolveTest.assertTrue((boolean)lpSolve.isConstrType(2, 2));
        LpSolveTest.assertFalse((boolean)lpSolve.isConstrType(2, 1));
        lpSolve.deleteLp();
    }

    public void testGetSolutioncount() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 0);
        lpSolve.setVerbose(3);
        lpSolve.solve();
        LpSolveTest.assertEquals((int)0, (int)lpSolve.getSolutioncount());
        lpSolve.deleteLp();
    }

    public void testGetSolutionlimit() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 0);
        lpSolve.setSolutionlimit(10);
        LpSolveTest.assertEquals((int)10, (int)lpSolve.getSolutionlimit());
        lpSolve.deleteLp();
    }

    public void testGetTotalIter() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 0);
        lpSolve.setVerbose(3);
        lpSolve.solve();
        LpSolveTest.assertEquals((long)0L, (long)lpSolve.getTotalIter());
        LpSolveTest.assertEquals((long)0L, (long)lpSolve.getTotalNodes());
        LpSolveTest.assertEquals((int)0, (int)lpSolve.getMaxLevel());
        lpSolve.deleteLp();
    }

    public void testGetSetBoundsTighter() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 0);
        LpSolveTest.assertFalse((boolean)lpSolve.getBoundsTighter());
        lpSolve.setBoundsTighter(true);
        LpSolveTest.assertTrue((boolean)lpSolve.getBoundsTighter());
        lpSolve.deleteLp();
    }

    public void testGetLpIndex() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 1);
        LpSolveTest.assertEquals((int)1, (int)lpSolve.getLpIndex(1));
        lpSolve.deleteLp();
    }

    public void testIsFeasible() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(1, 1);
        lpSolve.setVerbose(3);
        lpSolve.solve();
        double[] dArray = new double[]{0.0, 1.0, 2.0};
        LpSolveTest.assertTrue((boolean)lpSolve.isFeasible(dArray, 0.0));
        lpSolve.deleteLp();
    }

    public void testTimeElapsed() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 1);
        lpSolve.setVerbose(3);
        lpSolve.solve();
        lpSolve.timeElapsed();
        lpSolve.deleteLp();
    }

    public void testGetNameindexWithRows() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(2, 4);
        LpSolveTest.assertEquals((int)-1, (int)lpSolve.getNameindex("myrow1", true));
        lpSolve.setRowName(1, "myrow1");
        LpSolveTest.assertEquals((int)1, (int)lpSolve.getNameindex("myrow1", true));
        LpSolveTest.assertEquals((int)-1, (int)lpSolve.getNameindex("myrow2", true));
        lpSolve.setRowName(2, "myrow2");
        LpSolveTest.assertEquals((int)2, (int)lpSolve.getNameindex("myrow2", true));
        lpSolve.deleteLp();
    }

    public void testGetNameindexWithCols() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(2, 4);
        LpSolveTest.assertEquals((int)-1, (int)lpSolve.getNameindex("mycol1", false));
        lpSolve.setColName(1, "mycol1");
        LpSolveTest.assertEquals((int)1, (int)lpSolve.getNameindex("mycol1", false));
        LpSolveTest.assertEquals((int)-1, (int)lpSolve.getNameindex("mycol2", false));
        lpSolve.setColName(3, "mycol2");
        LpSolveTest.assertEquals((int)3, (int)lpSolve.getNameindex("mycol2", false));
        lpSolve.deleteLp();
    }

    public void testReadNonexistentBasis() throws Exception {
        String string = "model.bas";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.strSetObjFn("2 3 -2 3");
        try {
            lpSolve.readBasis(file.getAbsolutePath());
            LpSolveTest.fail((String)"readBasis should throw an Exception on nonexistent file");
        }
        catch (LpSolveException lpSolveException) {
            System.out.println("readBasis failed as expected");
        }
        lpSolve.deleteLp();
    }

    public void testReadWriteBasis() throws Exception {
        String string = "model.bas";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.strSetObjFn("2 3 -2 3");
        lpSolve.setVerbose(3);
        lpSolve.solve();
        lpSolve.writeBasis(file.getAbsolutePath());
        LpSolveTest.assertTrue((boolean)file.exists());
        String string2 = lpSolve.readBasis(file.getAbsolutePath());
        LpSolveTest.assertNotNull((Object)string2);
        LpSolveTest.assertTrue((string2.length() > 0 ? 1 : 0) != 0);
        lpSolve.deleteLp();
        if (file.exists()) {
            file.delete();
        }
    }

    public void testReadWriteParams() throws Exception {
        String string = "model.params";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((int)250, (int)lpSolve.getMaxpivot());
        lpSolve.setMaxpivot(400);
        lpSolve.writeParams(file.getAbsolutePath(), "");
        LpSolveTest.assertTrue((boolean)file.exists());
        lpSolve.deleteLp();
        lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((int)250, (int)lpSolve.getMaxpivot());
        lpSolve.readParams(file.getAbsolutePath(), "");
        LpSolveTest.assertEquals((int)400, (int)lpSolve.getMaxpivot());
        lpSolve.deleteLp();
        if (file.exists()) {
            file.delete();
        }
    }

    public void testResetParams() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        LpSolveTest.assertEquals((int)250, (int)lpSolve.getMaxpivot());
        lpSolve.setMaxpivot(400);
        LpSolveTest.assertEquals((int)400, (int)lpSolve.getMaxpivot());
        lpSolve.resetParams();
        LpSolveTest.assertEquals((int)250, (int)lpSolve.getMaxpivot());
        lpSolve.deleteLp();
    }

    public void testAbortListener() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        class MyListener
        implements AbortListener {
            public int numCalls = 0;
            private final /* synthetic */ LpSolve val$problem;

            MyListener(LpSolve lpSolve) {
                this.val$problem = lpSolve;
            }

            public boolean abortfunc(LpSolve lpSolve, Object object) {
                ++this.numCalls;
                Assert.assertEquals((Object)this.val$problem, (Object)lpSolve);
                Assert.assertEquals((Object)new Integer(123), (Object)object);
                return false;
            }
        }
        MyListener myListener = new MyListener(lpSolve);
        lpSolve.putAbortfunc(myListener, new Integer(123));
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.strSetObjFn("2 3 -2 3");
        lpSolve.setVerbose(3);
        lpSolve.solve();
        lpSolve.deleteLp();
        LpSolveTest.assertTrue((myListener.numCalls > 0 ? 1 : 0) != 0);
    }

    public void testMsgListener() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 4);
        class MyListener
        implements MsgListener {
            public int numCalls = 0;
            private final /* synthetic */ LpSolve val$problem;

            MyListener(LpSolve lpSolve) {
                this.val$problem = lpSolve;
            }

            public void msgfunc(LpSolve lpSolve, Object object, int n) throws LpSolveException {
                ++this.numCalls;
                Assert.assertEquals((Object)this.val$problem, (Object)lpSolve);
                Assert.assertEquals((Object)new Integer(123), (Object)object);
                this.val$problem.getWorkingObjective();
            }
        }
        MyListener myListener = new MyListener(lpSolve);
        int n = 24;
        lpSolve.putMsgfunc(myListener, new Integer(123), n);
        lpSolve.strAddConstraint("3 2 2 1", 1, 4.0);
        lpSolve.strAddConstraint("0 4 3 1", 2, 3.0);
        lpSolve.strSetObjFn("2 3 -2 3");
        lpSolve.setVerbose(3);
        lpSolve.solve();
        lpSolve.deleteLp();
        LpSolveTest.assertTrue((myListener.numCalls > 0 ? 1 : 0) != 0);
    }

    public void testLogListener() throws Exception {
        LpSolve lpSolve = LpSolve.makeLp(0, 0);
        class MyListener
        implements LogListener {
            public int numCalls = 0;
            private final /* synthetic */ LpSolve val$problem;

            MyListener(LpSolve lpSolve) {
                this.val$problem = lpSolve;
            }

            public void logfunc(LpSolve lpSolve, Object object, String string) {
                ++this.numCalls;
                Assert.assertEquals((Object)this.val$problem, (Object)lpSolve);
                Assert.assertEquals((Object)new Integer(123), (Object)object);
                Assert.assertNotNull((Object)string);
            }
        }
        MyListener myListener = new MyListener(lpSolve);
        lpSolve.putLogfunc(myListener, new Integer(123));
        try {
            lpSolve.delColumn(1);
        }
        catch (LpSolveException lpSolveException) {
            System.out.println("delColumn failed as expected");
        }
        lpSolve.deleteLp();
        LpSolveTest.assertTrue((myListener.numCalls > 0 ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

