/*
 * Decompiled with CFR 0.152.
 */
package java_cup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java_cup.emit;
import java_cup.internal_error;
import java_cup.lalr_state;
import java_cup.lexer;
import java_cup.non_terminal;
import java_cup.parse_action_table;
import java_cup.parse_reduce_table;
import java_cup.parser;
import java_cup.production;
import java_cup.symbol_part;
import java_cup.terminal;

public class Main {
    protected static boolean print_progress = true;
    protected static boolean opt_dump_states = false;
    protected static boolean opt_dump_tables = false;
    protected static boolean opt_dump_grammar = false;
    protected static boolean opt_show_timing = false;
    protected static boolean opt_do_debug = false;
    protected static PrintWriter dump_writer = new PrintWriter(System.err);
    protected static boolean opt_compact_red = false;
    protected static boolean include_non_terms = false;
    protected static boolean no_summary = false;
    protected static int expect_conflicts = 0;
    protected static boolean lr_values = true;
    protected static boolean sym_interface = false;
    protected static boolean suppress_scanner = false;
    protected static String sourceDirName = null;
    protected static String destDirName = null;
    protected static String inputFileName = null;
    protected static String dumpFileName = null;
    protected static long start_time = 0L;
    protected static long prelim_end = 0L;
    protected static long parse_end = 0L;
    protected static long check_end = 0L;
    protected static long dump_end = 0L;
    protected static long build_end = 0L;
    protected static long nullability_end = 0L;
    protected static long first_end = 0L;
    protected static long machine_end = 0L;
    protected static long table_end = 0L;
    protected static long reduce_check_end = 0L;
    protected static long emit_end = 0L;
    protected static long final_time = 0L;
    protected static BufferedInputStream input_file;
    protected static PrintWriter parser_class_file;
    protected static PrintWriter symbol_class_file;
    protected static lalr_state start_state;
    protected static parse_action_table action_table;
    protected static parse_reduce_table reduce_table;

    private Main() {
    }

    public static void main(String[] stringArray) throws internal_error, IOException, Exception {
        boolean bl = false;
        start_time = System.currentTimeMillis();
        Main.parse_args(stringArray);
        emit.set_lr_values(lr_values);
        if (print_progress) {
            System.err.println("Opening files...");
        }
        File file = null;
        file = sourceDirName != null && inputFileName != null ? new File(sourceDirName, inputFileName) : (sourceDirName == null && inputFileName != null ? new File(inputFileName) : (sourceDirName != null && inputFileName == null ? new File(sourceDirName, emit.parser_class_name + ".cup") : null));
        try {
            if (file != null) {
                System.setIn(new FileInputStream(file));
            }
        }
        catch (IOException iOException) {
            Main.usage("Exception when opening file " + file);
        }
        input_file = new BufferedInputStream(System.in);
        File file2 = null;
        file2 = sourceDirName != null && dumpFileName != null ? new File(sourceDirName, dumpFileName) : (sourceDirName == null && dumpFileName != null ? new File(dumpFileName) : null);
        try {
            if (file2 != null) {
                dump_writer = new PrintWriter(new FileWriter(file2));
            }
        }
        catch (IOException iOException) {
            Main.usage("Exception when opening file " + file2);
        }
        prelim_end = System.currentTimeMillis();
        if (print_progress) {
            System.err.println("Parsing specification from standard input...");
        }
        Main.parse_grammar_spec();
        parse_end = System.currentTimeMillis();
        if (lexer.error_count == 0) {
            if (print_progress) {
                System.err.println("Checking specification...");
            }
            Main.check_unused();
            check_end = System.currentTimeMillis();
            if (print_progress) {
                System.err.println("Building parse tables...");
            }
            Main.build_parser();
            build_end = System.currentTimeMillis();
            if (lexer.error_count != 0) {
                opt_dump_tables = false;
            } else {
                if (print_progress) {
                    System.err.println("Writing parser...");
                }
                Main.open_files();
                Main.emit_parser();
                bl = true;
            }
        }
        emit_end = System.currentTimeMillis();
        if (opt_dump_grammar) {
            Main.dump_grammar();
        }
        if (opt_dump_states) {
            Main.dump_machine();
        }
        if (opt_dump_tables) {
            Main.dump_tables();
        }
        dump_writer.flush();
        dump_end = System.currentTimeMillis();
        if (print_progress) {
            System.err.println("Closing files...");
        }
        Main.close_files();
        if (!no_summary) {
            Main.emit_summary(bl);
        }
        if (lexer.error_count != 0) {
            System.exit(100);
        } else {
            System.exit(0);
        }
    }

    protected static void usage(String string) {
        System.err.println();
        System.err.println(string);
        System.err.println();
        System.err.println("Usage: java_cup [options] [filename]\n  and expects a specification file on standard input if no filename is given.\n  Legal options include:\n    -package name  specify package generated classes go in [default none]\n    -parser name   specify parser class name [default \"parser\"]\n    -symbols name  specify name for symbol constant class [default \"sym\"]\n    -interface     put symbols in an interface, rather than a class\n    -nonterms      put non terminals in symbol constant class\n    -expect #      number of conflicts expected/allowed [default 0]\n    -compact_red   compact tables by defaulting to most frequent reduce\n    -nowarn        don't warn about useless productions, etc.\n    -nosummary     don't print the usual summary of parse states, etc.\n    -nopositions   don't propagate the left and right token position values\n    -noscanner     don't refer to java_cup.runtime.Scanner\n    -progress      print messages to indicate progress of the system\n    -time          print time usage summary\n    -dump_grammar  produce a human readable dump of the symbols and grammar\n    -dump_states   produce a dump of parse state machine\n    -dump_tables   produce a dump of the parse tables\n    -dump          produce a dump of all of the above\n    -version       print the version information for CUP and exit\n    -dumpto name   write dump output to specified file instead of STDERR\n    -source directory    use the specified source directory\n    -dest directory    use the specified dest directory\n    -input file    use the specified file rather than standard input\n");
        System.exit(1);
    }

    protected static void parse_args(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equals("-package")) {
                if (++i >= n || stringArray[i].startsWith("-") || stringArray[i].endsWith(".cup")) {
                    Main.usage("-package must have a name argument");
                }
                emit.package_name = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-parser")) {
                if (++i >= n || stringArray[i].startsWith("-") || stringArray[i].endsWith(".cup")) {
                    Main.usage("-parser must have a name argument");
                }
                emit.parser_class_name = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-symbols")) {
                if (++i >= n || stringArray[i].startsWith("-") || stringArray[i].endsWith(".cup")) {
                    Main.usage("-symbols must have a name argument");
                }
                emit.symbol_const_class_name = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-dumpto")) {
                if (++i >= n || stringArray[i].startsWith("-")) {
                    Main.usage("-dumpto must have a name argument");
                }
                dumpFileName = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-source")) {
                if (++i >= n || stringArray[i].startsWith("-")) {
                    Main.usage("-source must have a directory name argument");
                }
                sourceDirName = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-dest")) {
                if (++i >= n || stringArray[i].startsWith("-")) {
                    Main.usage("-source must have a directory name argument");
                }
                destDirName = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-input")) {
                if (++i >= n || stringArray[i].startsWith("-") || !stringArray[i].endsWith(".cup")) {
                    Main.usage("-input must have a filename argument of the form *.cup");
                }
                inputFileName = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-nonterms")) {
                include_non_terms = true;
                continue;
            }
            if (stringArray[i].equals("-expect")) {
                if (++i >= n || stringArray[i].startsWith("-") || stringArray[i].endsWith(".cup")) {
                    Main.usage("-expect must have a name argument");
                }
                try {
                    expect_conflicts = Integer.parseInt(stringArray[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    Main.usage("-expect must be followed by a decimal integer");
                }
                continue;
            }
            if (stringArray[i].equals("-compact_red")) {
                opt_compact_red = true;
                continue;
            }
            if (stringArray[i].equals("-nosummary")) {
                no_summary = true;
                continue;
            }
            if (stringArray[i].equals("-nowarn")) {
                emit.nowarn = true;
                continue;
            }
            if (stringArray[i].equals("-dump_states")) {
                opt_dump_states = true;
                continue;
            }
            if (stringArray[i].equals("-dump_tables")) {
                opt_dump_tables = true;
                continue;
            }
            if (stringArray[i].equals("-progress")) {
                print_progress = true;
                continue;
            }
            if (stringArray[i].equals("-dump_grammar")) {
                opt_dump_grammar = true;
                continue;
            }
            if (stringArray[i].equals("-dump")) {
                opt_dump_grammar = true;
                opt_dump_tables = true;
                opt_dump_states = true;
                continue;
            }
            if (stringArray[i].equals("-time")) {
                opt_show_timing = true;
                continue;
            }
            if (stringArray[i].equals("-debug")) {
                opt_do_debug = true;
                continue;
            }
            if (stringArray[i].equals("-nopositions")) {
                lr_values = false;
                continue;
            }
            if (stringArray[i].equals("-interface")) {
                sym_interface = true;
                continue;
            }
            if (stringArray[i].equals("-noscanner")) {
                suppress_scanner = true;
                continue;
            }
            if (stringArray[i].equals("-version")) {
                System.out.println("CUP v0.10k");
                System.exit(1);
                continue;
            }
            if (!stringArray[i].startsWith("-") && i == n - 1) {
                try {
                    System.setIn(new FileInputStream(stringArray[i]));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Main.usage("Unable to open \"" + stringArray[i] + "\" for input");
                }
                continue;
            }
            Main.usage("Unrecognized option \"" + stringArray[i] + "\"");
        }
    }

    protected static void open_files() {
        if (destDirName == null) {
            destDirName = sourceDirName;
        }
        String string = emit.parser_class_name + ".java";
        File file = destDirName == null ? new File(string) : new File(destDirName, string);
        try {
            parser_class_file = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file), 4096));
        }
        catch (Exception exception) {
            System.err.println("Can't open \"" + string + "\" for output");
            System.exit(3);
        }
        string = emit.symbol_const_class_name + ".java";
        file = destDirName == null ? new File(string) : new File(destDirName, string);
        try {
            symbol_class_file = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file), 4096));
        }
        catch (Exception exception) {
            System.err.println("Can't open \"" + string + "\" for output");
            System.exit(4);
        }
    }

    protected static void close_files() throws IOException {
        if (input_file != null) {
            input_file.close();
        }
        if (parser_class_file != null) {
            parser_class_file.close();
        }
        if (symbol_class_file != null) {
            symbol_class_file.close();
        }
    }

    protected static void parse_grammar_spec() throws Exception {
        parser parser2 = new parser();
        try {
            if (opt_do_debug) {
                parser2.debug_parse();
            } else {
                parser2.parse();
            }
        }
        catch (Exception exception) {
            lexer.emit_error("Internal error: Unexpected exception");
            throw exception;
        }
    }

    protected static void check_unused() {
        Enumeration enumeration = terminal.all();
        while (enumeration.hasMoreElements()) {
            terminal terminal2 = (terminal)enumeration.nextElement();
            if (terminal2 == terminal.EOF || terminal2 == terminal.error || terminal2.use_count() != 0) continue;
            ++emit.unused_term;
            if (emit.nowarn) continue;
            System.err.println("Warning: Terminal \"" + terminal2.name() + "\" was declared but never used");
            ++lexer.warning_count;
        }
        enumeration = non_terminal.all();
        while (enumeration.hasMoreElements()) {
            non_terminal non_terminal2 = (non_terminal)enumeration.nextElement();
            if (non_terminal2.use_count() != 0) continue;
            ++emit.unused_term;
            if (emit.nowarn) continue;
            System.err.println("Warning: Non terminal \"" + non_terminal2.name() + "\" was declared but never used");
            ++lexer.warning_count;
        }
    }

    protected static void build_parser() throws internal_error {
        if (opt_do_debug || print_progress) {
            System.err.println("  Computing non-terminal nullability...");
        }
        non_terminal.compute_nullability();
        nullability_end = System.currentTimeMillis();
        if (opt_do_debug || print_progress) {
            System.err.println("  Computing first sets...");
        }
        non_terminal.compute_first_sets();
        first_end = System.currentTimeMillis();
        if (opt_do_debug || print_progress) {
            System.err.println("  Building state machine...");
        }
        start_state = lalr_state.build_machine(emit.start_production);
        machine_end = System.currentTimeMillis();
        if (opt_do_debug || print_progress) {
            System.err.println("  Filling in tables...");
        }
        action_table = new parse_action_table();
        reduce_table = new parse_reduce_table();
        Enumeration enumeration = lalr_state.all();
        while (enumeration.hasMoreElements()) {
            lalr_state lalr_state2 = (lalr_state)enumeration.nextElement();
            lalr_state2.build_table_entries(action_table, reduce_table);
        }
        table_end = System.currentTimeMillis();
        if (opt_do_debug || print_progress) {
            System.err.println("  Checking for non-reduced productions...");
        }
        action_table.check_reductions();
        reduce_check_end = System.currentTimeMillis();
        if (emit.num_conflicts > expect_conflicts) {
            System.err.println("*** More conflicts encountered than expected -- parser generation aborted");
            ++lexer.error_count;
        }
    }

    protected static void emit_parser() throws internal_error {
        emit.symbols(symbol_class_file, include_non_terms, sym_interface);
        emit.parser(parser_class_file, action_table, reduce_table, start_state.index(), emit.start_production, opt_compact_red, suppress_scanner);
    }

    protected static String plural(int n) {
        if (n == 1) {
            return "";
        }
        return "s";
    }

    protected static void emit_summary(boolean bl) {
        final_time = System.currentTimeMillis();
        if (no_summary) {
            return;
        }
        System.err.println("------- CUP v0.10k Parser Generation Summary -------");
        System.err.println("  " + lexer.error_count + " error" + Main.plural(lexer.error_count) + " and " + lexer.warning_count + " warning" + Main.plural(lexer.warning_count));
        System.err.print("  " + terminal.number() + " terminal" + Main.plural(terminal.number()) + ", ");
        System.err.print(non_terminal.number() + " non-terminal" + Main.plural(non_terminal.number()) + ", and ");
        System.err.println(production.number() + " production" + Main.plural(production.number()) + " declared, ");
        System.err.println("  producing " + lalr_state.number() + " unique parse states.");
        System.err.println("  " + emit.unused_term + " terminal" + Main.plural(emit.unused_term) + " declared but not used.");
        System.err.println("  " + emit.unused_non_term + " non-terminal" + Main.plural(emit.unused_term) + " declared but not used.");
        System.err.println("  " + emit.not_reduced + " production" + Main.plural(emit.not_reduced) + " never reduced.");
        System.err.println("  " + emit.num_conflicts + " conflict" + Main.plural(emit.num_conflicts) + " detected" + " (" + expect_conflicts + " expected).");
        if (bl) {
            System.err.println("  Code written to \"" + emit.parser_class_name + ".java\", and \"" + emit.symbol_const_class_name + ".java\".");
        } else {
            System.err.println("  No code produced.");
        }
        if (opt_show_timing) {
            Main.show_times();
        }
        System.err.println("---------------------------------------------------- (v0.10k)");
    }

    protected static void show_times() {
        long l = final_time - start_time;
        System.err.println(". . . . . . . . . . . . . . . . . . . . . . . . . ");
        System.err.println("  Timing Summary");
        System.err.println("    Total time       " + Main.timestr(final_time - start_time, l));
        System.err.println("      Startup        " + Main.timestr(prelim_end - start_time, l));
        System.err.println("      Parse          " + Main.timestr(parse_end - prelim_end, l));
        if (check_end != 0L) {
            System.err.println("      Checking       " + Main.timestr(check_end - parse_end, l));
        }
        if (check_end != 0L && build_end != 0L) {
            System.err.println("      Parser Build   " + Main.timestr(build_end - check_end, l));
        }
        if (nullability_end != 0L && check_end != 0L) {
            System.err.println("        Nullability  " + Main.timestr(nullability_end - check_end, l));
        }
        if (first_end != 0L && nullability_end != 0L) {
            System.err.println("        First sets   " + Main.timestr(first_end - nullability_end, l));
        }
        if (machine_end != 0L && first_end != 0L) {
            System.err.println("        State build  " + Main.timestr(machine_end - first_end, l));
        }
        if (table_end != 0L && machine_end != 0L) {
            System.err.println("        Table build  " + Main.timestr(table_end - machine_end, l));
        }
        if (reduce_check_end != 0L && table_end != 0L) {
            System.err.println("        Checking     " + Main.timestr(reduce_check_end - table_end, l));
        }
        if (emit_end != 0L && build_end != 0L) {
            System.err.println("      Code Output    " + Main.timestr(emit_end - build_end, l));
        }
        if (emit.symbols_time != 0L) {
            System.err.println("        Symbols      " + Main.timestr(emit.symbols_time, l));
        }
        if (emit.parser_time != 0L) {
            System.err.println("        Parser class " + Main.timestr(emit.parser_time, l));
        }
        if (emit.action_code_time != 0L) {
            System.err.println("          Actions    " + Main.timestr(emit.action_code_time, l));
        }
        if (emit.production_table_time != 0L) {
            System.err.println("          Prod table " + Main.timestr(emit.production_table_time, l));
        }
        if (emit.action_table_time != 0L) {
            System.err.println("          Action tab " + Main.timestr(emit.action_table_time, l));
        }
        if (emit.goto_table_time != 0L) {
            System.err.println("          Reduce tab " + Main.timestr(emit.goto_table_time, l));
        }
        System.err.println("      Dump Output    " + Main.timestr(dump_end - emit_end, l));
    }

    protected static String timestr(long l, long l2) {
        boolean bl;
        long l3 = 0L;
        long l4 = 0L;
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        l3 = l % 1000L;
        l4 = l / 1000L;
        String string = l4 < 10L ? "   " : (l4 < 100L ? "  " : (l4 < 1000L ? " " : ""));
        long l5 = l * 1000L / l2;
        return (bl ? "-" : "") + string + l4 + "." + l3 % 1000L / 100L + l3 % 100L / 10L + l3 % 10L + "sec" + " (" + l5 / 10L + "." + l5 % 10L + "%)";
    }

    public static void dump_grammar() throws internal_error {
        dump_writer.println("===== Terminals =====");
        int n = 0;
        int n2 = 0;
        while (n < terminal.number()) {
            dump_writer.print("[" + n + "] " + terminal.find(n).name() + " ");
            if ((n2 + 1) % 5 == 0) {
                dump_writer.println();
            }
            ++n;
            ++n2;
        }
        dump_writer.println();
        dump_writer.println();
        dump_writer.println("===== Nonterminals =====");
        n = 0;
        n2 = 0;
        while (n < non_terminal.number()) {
            dump_writer.print("[" + n + "] " + non_terminal.find(n).name() + " ");
            if ((n2 + 1) % 5 == 0) {
                dump_writer.println();
            }
            ++n;
            ++n2;
        }
        dump_writer.println();
        dump_writer.println();
        dump_writer.println("===== Rules =====");
        for (n = 0; n < production.number(); ++n) {
            production production2 = production.find(n);
            dump_writer.print("[" + n + "] " + production2.lhs().the_symbol().name() + " ::= ");
            for (int i = 0; i < production2.rhs_length(); ++i) {
                if (production2.rhs(i).is_action()) {
                    dump_writer.print("{action} ");
                    continue;
                }
                dump_writer.print(((symbol_part)production2.rhs(i)).the_symbol().name() + " ");
            }
            dump_writer.println();
        }
        dump_writer.println();
    }

    public static void dump_machine() {
        lalr_state[] lalr_stateArray = new lalr_state[lalr_state.number()];
        Enumeration enumeration = lalr_state.all();
        while (enumeration.hasMoreElements()) {
            lalr_state lalr_state2;
            lalr_stateArray[lalr_state2.index()] = lalr_state2 = (lalr_state)enumeration.nextElement();
        }
        dump_writer.println("===== LALR(1) States =====");
        for (int i = 0; i < lalr_state.number(); ++i) {
            if (lalr_stateArray[i] == start_state) {
                dump_writer.print("START ");
            }
            dump_writer.println(lalr_stateArray[i]);
            dump_writer.println("-------------------");
        }
    }

    public static void dump_tables() {
        dump_writer.println(action_table);
        dump_writer.println(reduce_table);
    }
}

