import json
import io

class Square:
#The Square class creates a new square with the specified length.

	def __init__(self, len):
	#Creates a new instance of Square with a specified length.
		self.side_length = len

	def __str__(self):
		return str(self.side_length) + ' x ' + str(self.side_length) + ' square'

	def __repr__(self):
		return 'Square({0})'.format(self.side_length)

def write(data, filename):
#Write a square to a file
	file = open(filename, 'w')
	str_out = json.dumps(data,sort_keys=True,indent=4)
	file.write(str_out)
	file.close()

def read(filename):
#Read a square from a file
	file = open(filename)
	str_in = file.read()
	file.close()
	data = json.loads(str_in)
	return data


s = Square(10)
file_name = 'test_square.txt'
my_dict = {'__class__': 'Square', 'side_length' : s.side_length}
write(my_dict, file_name)


#read from a file
data = read(file_name)
result = Square( data['side_length'] )
print (result)