"""GUI - create a top level window containing a Canvas object
Author: Adriana Ferraro
"""
from tkinter import *

def rectangular_grid(a_canvas):
	number_of_rows = 5
	left_hand_side = 20
	y_down = 30
	size = 40
	first_is_circle = True
	for number_to_do in range(number_of_rows, 0, -1):
		x_left = left_hand_side
		is_circle = first_is_circle
		for j in range(number_to_do):
			rect = (x_left + 2, y_down + 2, x_left + size - 2,
y_down + size - 2)
			if is_circle:
				a_canvas.create_oval(rect)
			else:
				a_canvas.create_rectangle(rect)
			x_left =x_left +  size
			is_circle = not is_circle

		y_down = y_down + size
		first_is_circle = not first_is_circle


def main():
	root = Tk()
	root.title("My first Canvas")
	root.geometry("400x300+10+20")
	a_canvas = Canvas(root)

	a_canvas.config(background="pink")
	a_canvas.pack(fill=BOTH, expand = True) #Canvas fills the whole top level window

	rectangular_grid(a_canvas)

	root.mainloop()

main()
