"""Code from lecture 23
Creating and using dictionary objects
"""

def main():
	film_list = ["Jaws", "The Goonies", "Aliens", "Commando"]
	number_of_films = len(film_list)
	filename = "Ratings.txt"	
	lines_of_text = get_lines_from_file(filename)	
	people_ratings_dict = get_people_ratings_dict(lines_of_text)
	film_ratings_dict = get_film_ratings_dict(film_list, people_ratings_dict)
	
	print()	
	print("Process Film-Rating Request")
	process_film_ratings_request(film_list, film_ratings_dict)

#----------------------------------------------------------
# PROCESS FILM RATING REQUEST
#----------------------------------------------------------
def process_film_ratings_request(film_list, film_ratings_dict):
        display_numbered_list(film_list)
        user_selection = int(input("Enter selection: "))
        film_selected = film_list[user_selection - 1] #assuming valid user input
        film_reviews = film_ratings_dict[film_selected]
        average_rating = get_average_rating(film_reviews)
        print(film_reviews,film_selected,"- average rating:",average_rating) 

	
def get_average_rating(list_of_numbers):
        total = 0
        non_zero_count = 0
        for number in list_of_numbers:
                if number > 0:
                        total += number
                        non_zero_count += 1
        if non_zero_count == 0:
                return 0.0
        else:
                return round(total / non_zero_count,1)

def display_numbered_list(list_of_items):
        count = 1
        for item in list_of_items:
                print(count,item)
                count += 1

#-----------------------------------------------------------
#BUILD DICTIONARIES FROM TEXT FILE INFORMATION
#-----------------------------------------------------------
def get_film_ratings_dict(film_list, people_ratings_dict):
        film_ratings = {}
        film_index = 0
        for i in range(len(film_list)):
                film_name = film_list[i]
                reviews_list = []
                for reviewer in people_ratings_dict:
                        reviewer_scores = people_ratings_dict[reviewer]
                        movie_review = reviewer_scores[i]
                        reviews_list.append(movie_review)
                film_ratings[film_name] = reviews_list
        return film_ratings

def get_people_ratings_dict(lines_of_text):
        people_ratings = {}
        for reviewer in lines_of_text:
                reviewer_info = reviewer.split(" ")
                reviewer_name = reviewer_info[0]
                reviewer_ratings = reviewer_info[1:]
                for i in range(len(reviewer_ratings)):
                        reviewer_ratings[i] = int(reviewer_ratings[i])
                people_ratings[reviewer_name] = reviewer_ratings
        return people_ratings

def get_lines_from_file(filename):
        file = open(filename,"r")
        lines = file.read().strip()
        file.close()
        lines_list = lines.split("\n")
        return lines_list
	
main()

