namespace OnlineSurvey
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;

	using System.Configuration;
	using System.Data.SqlClient;
	using System.Web.Security;

	/// <summary>
	///		TopBar   Դϴ.
	/// </summary>
	public class TopBar : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.Label lblID;
		protected System.Web.UI.WebControls.TextBox txtID;
		protected System.Web.UI.WebControls.Label lblPassword;
		protected System.Web.UI.WebControls.TextBox txtPassword;
		protected System.Web.UI.WebControls.Button btnLogin;
		protected System.Web.UI.WebControls.Button btnLogout;
		protected System.Web.UI.WebControls.Button btnCreateAccount;
		protected System.Web.UI.WebControls.Button btnAdmin;
		protected System.Web.UI.WebControls.Button btnMakeSurvey;

		private void Page_Load(object sender, System.EventArgs e)
		{
			
			// ⿡  ڵ带 ġϿ  ʱȭմϴ.
			if(Page.User.Identity.IsAuthenticated)
			{
				lblID.Text = Page.User.Identity.Name + " is logged.";
				txtID.Visible = false;
				lblPassword.Visible = txtPassword.Visible = false;
				btnLogin.Visible = false;
				btnCreateAccount.Visible = false;
				btnLogout.Visible = true;
				btnMakeSurvey.Visible = true;
				if(Page.User.Identity.Name == "admin")
					btnAdmin.Visible = true;
			}
		}

		#region Web Form ̳ʿ  ڵ
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN:  ȣ ASP.NET Web Form ̳ʿ ʿմϴ.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		///		̳  ʿ ޼Դϴ.  ޼ 
		///		ڵ   ʽÿ.
		/// </summary>
		private void InitializeComponent()
		{
			this.btnLogin.Click += new System.EventHandler(this.btnLogin_Click);
			this.btnLogout.Click += new System.EventHandler(this.btnLogout_Click);
			this.btnCreateAccount.Click += new System.EventHandler(this.btnCreateAccount_Click);
			this.btnMakeSurvey.Click += new System.EventHandler(this.btnMakeSurvey_Click);
			this.btnAdmin.Click += new System.EventHandler(this.btnAdmin_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private bool Authenticate(string id, string pwd)
		{
			bool bExist = false;

			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "SELECT id FROM Members WHERE id = @ID AND pwd = @Pwd";
			Cmd.Parameters.Add("@ID", SqlDbType.VarChar, 20);
			Cmd.Parameters.Add("@Pwd", SqlDbType.VarChar, 20);

			Cmd.Parameters["@ID"].Value = id;
			Cmd.Parameters["@Pwd"].Value = pwd;
			try
			{
				Con.Open();
				if(Cmd.ExecuteScalar() != null)
				{
					bExist = true;
				}
			}
			catch (Exception ex) {}
			finally
			{
				Con.Close();
			}
			return bExist;
		}
		private void btnLogin_Click(object sender, System.EventArgs e)
		{
			string id = txtID.Text;
			string pwd = txtPassword.Text;
			if(Authenticate(id, pwd))
				FormsAuthentication.RedirectFromLoginPage(id, false);
			else
				Response.Redirect("default.aspx");
		}

		private void btnLogout_Click(object sender, System.EventArgs e)
		{
			FormsAuthentication.SignOut();
			Response.Redirect("default.aspx");
		}

		private void btnCreateAccount_Click(object sender, System.EventArgs e)
		{
			Response.Redirect("Register.aspx");
		}

		private void btnMakeSurvey_Click(object sender, System.EventArgs e)
		{
			Response.Redirect("MakeSurvey.aspx");
		}

		private void btnAdmin_Click(object sender, System.EventArgs e)
		{
			Response.Redirect("Admin.aspx");
		}
	}
}
