using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using System.Configuration;
using System.Data.SqlClient;
using System.Web.Security;

namespace OnlineSurvey
{
	/// <summary>
	/// SurveyManager   Դϴ.
	/// </summary>
	public class SurveyManager : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Label lblTitle;
		protected System.Web.UI.WebControls.DataList QuestionList;
	
		private string surveyTitle = null;
		private string dbName = null;
		private string surveyOwner = null;
		protected System.Web.UI.WebControls.Label lblError;
		protected System.Web.UI.WebControls.Panel panelAddQuestion;
		protected System.Web.UI.WebControls.Button btnAddQuestion;
		protected System.Web.UI.WebControls.DropDownList ddlQuestionType;
		protected System.Web.UI.WebControls.TextBox txtAddQuestion;
		/*public string[] QuestionTypeArray = { "Multiple Choice (select only one)",
												 "Multiple Choice (multiple selection)", "Short Answer",
												 "Multiple Choice (select only one) + Short Answer",
												 "Multiple Choice (multiple selection) + Short Answer",
												 "Yes/No" };*/
		public string[] QuestionTypeArray = { "Multiple Choice (select only one)",
												"Short Answer"
											};

		private void QuestionListBind()
		{
			string surveyID = Request.QueryString["surveyID"];
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlDataAdapter Adap = new SqlDataAdapter();			
			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "SELECT questionID, type, questionString FROM Questions WHERE surveyID = @surveyID";
			Cmd.Parameters.Add("@surveyID", SqlDbType.Int);
			Cmd.Parameters["@surveyID"].Value = surveyID;
			Adap.SelectCommand = Cmd;
			
			DataSet ds = new DataSet();
			Adap.Fill(ds, "questions");
			QuestionList.DataSource = ds.Tables["questions"];
			QuestionList.DataBind();
		}

		private bool GetSurveyInfo()
		{
			string surveyID = Request.QueryString["surveyID"];
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "SELECT * FROM Surveys WHERE surveyID = @surveyID";
			Cmd.Parameters.Add("@surveyID", SqlDbType.Int);
			Cmd.Parameters["@surveyID"].Value = surveyID;
			Con.Open();			
			SqlDataReader dr = Cmd.ExecuteReader(CommandBehavior.CloseConnection);
			if(dr.Read())
			{
				surveyTitle = dr["title"].ToString();
				dbName = dr["dbName"].ToString();
				surveyOwner = dr["userID"].ToString();
				dr.Close();
				return true;				
			}
			else 
			{
				dr.Close();
				return false;
			}
		}

		private void QuestionTypeBind()
		{
			ddlQuestionType.DataSource = QuestionTypeArray;
			ddlQuestionType.DataBind();
		}

		private void Page_Load(object sender, System.EventArgs e)
		{
			if(Request.QueryString["surveyID"] == null)
				Response.Redirect("Default.aspx");
			if(User.Identity.IsAuthenticated)
			{
				if(!GetSurveyInfo()) // survey ID ȿ  return
				{
					lblTitle.Text = "Invalid surveyID !";
					return;
				}
				//User  survey Owner  ƴϸ 
				if(User.Identity.Name != surveyOwner)
				{
					lblTitle.Text = "Permission error !";
					return;
				}

				if(!IsPostBack)
				{
					lblTitle.Text = surveyTitle;
					QuestionTypeBind();
					QuestionListBind();
				}
				panelAddQuestion.Visible = true;
			}
			else 
			{
				Response.Redirect("Default.aspx");
			}
		}

		#region Web Form ̳ʿ  ڵ
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN:  ȣ ASP.NET Web Form ̳ʿ ʿմϴ.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// ̳  ʿ ޼Դϴ.
		///  ޼  ڵ   ʽÿ.
		/// </summary>
		private void InitializeComponent()
		{    
			this.QuestionList.ItemCommand += new System.Web.UI.WebControls.DataListCommandEventHandler(this.QuestionList_ItemCommand);
			this.QuestionList.CancelCommand += new System.Web.UI.WebControls.DataListCommandEventHandler(this.QuestionList_CancelCommand);
			this.QuestionList.EditCommand += new System.Web.UI.WebControls.DataListCommandEventHandler(this.QuestionList_EditCommand);
			this.QuestionList.UpdateCommand += new System.Web.UI.WebControls.DataListCommandEventHandler(this.QuestionList_UpdateCommand);
			this.QuestionList.DeleteCommand += new System.Web.UI.WebControls.DataListCommandEventHandler(this.QuestionList_DeleteCommand);
			this.btnAddQuestion.Click += new System.EventHandler(this.btnAddQuestion_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void btnAddQuestion_Click(object sender, System.EventArgs e)
		{
			//Questions INSERT INTO ϰ			
			//dbName column ߰Ѵ.
			string questionString = txtAddQuestion.Text;
			int questionType = ddlQuestionType.SelectedIndex;
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);

			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "INSERT INTO Questions (surveyID, type, questionString ) " +
				"VALUES (@surveyID, @type, @questionString)";
			Cmd.Parameters.Add("@surveyID",SqlDbType.Int);
			Cmd.Parameters.Add("@type",SqlDbType.Int);
			Cmd.Parameters.Add("@questionString",SqlDbType.VarChar, 100);

			Cmd.Parameters["@surveyID"].Value = Request.QueryString["surveyID"];
			Cmd.Parameters["@type"].Value = questionType;
			Cmd.Parameters["@questionString"].Value = questionString;
			
			SqlCommand Cmd2 = new SqlCommand();
			Cmd2.Connection = Con;
			Cmd2.CommandText = "SELECT questionID FROM Questions  WHERE surveyID=@surveyID AND type=@type AND questionString=@questionString ";
			Cmd2.Parameters.Add("@surveyID",SqlDbType.Int);
			Cmd2.Parameters.Add("@type",SqlDbType.Int);
			Cmd2.Parameters.Add("@questionString",SqlDbType.VarChar, 100);
			Cmd2.Parameters["@surveyID"].Value = Request.QueryString["surveyID"];
			Cmd2.Parameters["@type"].Value = questionType;
			Cmd2.Parameters["@questionString"].Value = questionString;

			Con.Open();
			SqlTransaction trans = Con.BeginTransaction();
			try
			{
				
				Cmd.Transaction = trans;
				Cmd2.Transaction = trans;
				
				Cmd.ExecuteNonQuery();
				string questionID = Cmd2.ExecuteScalar().ToString();

				SqlCommand Cmd3 = new SqlCommand();
				Cmd3.Connection = Con;
				Cmd3.CommandText = "ALTER TABLE " +  dbName + 
					" ADD q" + questionID + " varchar(100) NULL";
				Cmd3.Transaction = trans;
				Cmd3.ExecuteNonQuery();

				SqlCommand Cmd4 = new SqlCommand();
				Cmd4.Connection = Con;
				Cmd4.CommandText = "UPDATE Surveys " +
					"SET questionCount = questionCount + 1 " +
					"WHERE surveyID = " + Request.QueryString["surveyID"];
				Cmd4.Transaction = trans;
				Cmd4.ExecuteNonQuery();

				trans.Commit();
			}
			catch(Exception ex)
			{
				trans.Rollback();
				lblError.Text = "DB Access error !<br/>";
				lblError.Text += ex.Message;
			}
			finally
			{
				Con.Close();
			}
			ddlQuestionType.SelectedIndex = 0;
			txtAddQuestion.Text = "";
			QuestionListBind();
		}

		private void QuestionList_EditCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
		{
			QuestionList.EditItemIndex = e.Item.ItemIndex;
			QuestionListBind();
		}

		private void QuestionList_ItemCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
		{
			if(e.CommandName == "manager")
			{
				Response.Redirect("QuestionManager.aspx?questionID="+ QuestionList.DataKeys[e.Item.ItemIndex].ToString());
			}
		}

		private void QuestionList_DeleteCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
		{
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlConnection Con2 = new SqlConnection(ConnectStr);
			string strSQL;
			strSQL = "DELETE FROM Questions WHERE questionID = @questionID";			
			SqlCommand Cmd = new SqlCommand(strSQL, Con);
			Cmd.Parameters.Add("@questionID", SqlDbType.Int);
			Cmd.Parameters["@questionID"].Value = QuestionList.DataKeys[e.Item.ItemIndex];
			
			SqlCommand Cmd2 = new SqlCommand("SELECT optionID FROM Options WHERE questionID=@questionID",Con2);
			Cmd2.Parameters.Add("@questionID", SqlDbType.Int);
			Cmd2.Parameters["@questionID"].Value = QuestionList.DataKeys[e.Item.ItemIndex];
			Con2.Open();
			
			Con.Open();				
			SqlTransaction trans = Con.BeginTransaction();
			try
			{
				Cmd.Transaction = trans;
				SqlDataReader dr = Cmd2.ExecuteReader();
				while(dr.Read())
				{
					SqlCommand Cmd3 = new SqlCommand("DELETE FROM Options WHERE optionID = @OptionID",Con);
					Cmd3.Parameters.Add("@OptionID", SqlDbType.Int);
					Cmd3.Parameters["@OptionID"].Value = dr["optionID"];
					Cmd3.Transaction = trans;
					Cmd3.ExecuteNonQuery();
				}
				Cmd.ExecuteNonQuery();
				trans.Commit();
			}	
			catch(Exception ex)
			{
				trans.Rollback();
				lblError.Text = "DB Access error !<br/>";
				lblError.Text += ex.Message;
			}
			finally
			{
				Con.Close();
			}

			QuestionList.EditItemIndex = -1;
			QuestionListBind();			
		}

		private void QuestionList_CancelCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
		{
			QuestionList.EditItemIndex = -1;
			QuestionListBind();
		
		}

		private void QuestionList_UpdateCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
		{			
			string questionString = ((TextBox)e.Item.FindControl("questionString")).Text;
			string questionID = QuestionList.DataKeys[e.Item.ItemIndex].ToString();
			string strSQL;
			strSQL = "UPDATE Questions SET questionString=@questionString WHERE questionID = @questionID";
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlCommand Cmd = new SqlCommand(strSQL, Con);

			Cmd.Parameters.Add("@questionString", SqlDbType.VarChar, 100);
			Cmd.Parameters.Add("@questionID", SqlDbType.Int);			
			Cmd.Parameters["@questionString"].Value = questionString;
			Cmd.Parameters["@questionID"].Value = questionID;
			
			Con.Open();
			Cmd.ExecuteNonQuery();
			Con.Close();

			QuestionList.EditItemIndex = -1;
			QuestionListBind();
		}
	}
}
