using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using System.Configuration;
using System.Data.SqlClient;
using System.Web.Security;

namespace OnlineSurvey
{
	/// <summary>
	/// Survey   Դϴ.
	/// </summary>
	public class Survey : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Label lblError;
		protected System.Web.UI.WebControls.DataList QuestionList;
		protected System.Web.UI.WebControls.Label lblTitle;
	
		private string surveyTitle = null;
		private string dbName = null;
		protected System.Web.UI.WebControls.Button btnSubmit;
		private string surveyOwner = null;
		private int numberOfQuestions;
		
		private bool GetSurveyInfo()
		{
			string surveyID = Request.QueryString["surveyID"];
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "SELECT * FROM Surveys WHERE surveyID = @surveyID";
			Cmd.Parameters.Add("@surveyID", SqlDbType.Int);
			Cmd.Parameters["@surveyID"].Value = surveyID;
			Con.Open();			
			SqlDataReader dr = Cmd.ExecuteReader(CommandBehavior.CloseConnection);
			if(dr.Read())
			{
				surveyTitle = dr["title"].ToString();
				dbName = dr["dbName"].ToString();
				surveyOwner = dr["userID"].ToString();
				numberOfQuestions = (int)dr["questionCount"];
				dr.Close();
				return true;				
			}
			else 
			{
				dr.Close();
				return false;
			}
		}

		private void QuestionListBind()
		{
			string surveyID = Request.QueryString["surveyID"];
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlDataAdapter Adap = new SqlDataAdapter();			
			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "SELECT questionID, type, questionString FROM Questions WHERE surveyID = @surveyID";
			Cmd.Parameters.Add("@surveyID", SqlDbType.Int);
			Cmd.Parameters["@surveyID"].Value = surveyID;
			Adap.SelectCommand = Cmd;
			
			DataSet ds = new DataSet();
			Adap.Fill(ds, "questions");
			QuestionList.DataSource = ds.Tables["questions"];
			QuestionList.DataBind();
		}

		private void Page_Load(object sender, System.EventArgs e)
		{
			if(Request.QueryString["surveyID"] == null)
				Response.Redirect("Default.aspx");

			if(!GetSurveyInfo()) // survey ID ȿ  return
			{
				lblTitle.Text = "Invalid surveyID !";
				return;
			}
			
			if(!IsPostBack)
			{
				lblTitle.Text = surveyTitle;				
				QuestionListBind();
			}
			if(numberOfQuestions > 0)
				btnSubmit.Visible = true;
			else
				lblError.Text = "No questions!";
			
		}

		#region Web Form ̳ʿ  ڵ
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN:  ȣ ASP.NET Web Form ̳ʿ ʿմϴ.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// ̳  ʿ ޼Դϴ.
		///  ޼  ڵ   ʽÿ.
		/// </summary>
		private void InitializeComponent()
		{    
			this.btnSubmit.Click += new System.EventHandler(this.btnSubmit_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void btnSubmit_Click(object sender, System.EventArgs e)
		{
			string columnList = "(";
			string valueList = "(";
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "INSERT INTO " + dbName + " ";

			foreach(DataListItem item in QuestionList.Items)
			{	
				AnswerControl ac = (AnswerControl)item.FindControl("answer");
				string question_id = "q" + QuestionList.DataKeys[item.ItemIndex].ToString();
				Cmd.Parameters.Add("@"+question_id, SqlDbType.VarChar, 100);
				columnList += question_id + ", ";
				if( ac.lblType.Text== "0" ) // Multiple choice ( select only one )
				{					
					valueList +=  ac.OptionList.SelectedIndex + ", ";
					Cmd.Parameters["@"+question_id].Value = ac.OptionList.SelectedIndex;
				}
				else if (ac.lblType.Text== "1") // Short Answer
				{
					valueList +=  "\'"+ac.txtShortAnswer.Text + "\', ";
					Cmd.Parameters["@"+question_id].Value = ac.txtShortAnswer.Text;
				}
			}
			
			columnList = columnList.Remove(columnList.Length-2,1);
			valueList = valueList.Remove(valueList.Length-2,1);
			
			columnList += ")";
			valueList += ")";
			lblError.Text += columnList + "<br/>";
			lblError.Text += valueList + "<br/>";
			Cmd.CommandText += columnList;
			Cmd.CommandText += " VALUES " + valueList;
			lblError.Text += Cmd.CommandText;
			
			SqlTransaction trans = null;
			try
			{
				SqlCommand Cmd2 = new SqlCommand();
				Cmd2.Connection = Con;
				Cmd2.CommandText = "UPDATE Surveys " +
					"SET surveyCount = surveyCount + 1 " +
					"WHERE surveyID = " + Request.QueryString["surveyID"];
				

				Con.Open();
				trans = Con.BeginTransaction();
				Cmd.Transaction = trans;
				Cmd2.Transaction = trans;
				
				Cmd.ExecuteNonQuery();
				Cmd2.ExecuteNonQuery();
				string script = "<script>";
				script += " alert('Your survey has been succesffuly submitted'); ";
				script += " location.href='default.aspx'; ";
				script += "</script>";
				this.RegisterClientScriptBlock("created",script);
				trans.Commit();
			}
			catch(Exception ex)
			{
				if(trans != null)
					trans.Rollback();
				lblError.Text = "DB Access error !<br/>";
				lblError.Text += ex.Message;				
			}
			finally
			{
				Con.Close();
			}			
		}
	}
}
