using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using System.Configuration;
using System.Data.SqlClient;
using System.Web.Security;

namespace OnlineSurvey
{
	/// <summary>
	/// Register   Դϴ.
	/// </summary>
	public class Register : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Button btnCreateAccount;
		protected System.Web.UI.WebControls.Label lblError;
		protected System.Web.UI.WebControls.TextBox txtID;
		protected System.Web.UI.WebControls.RequiredFieldValidator RequiredFieldValidator1;
		protected System.Web.UI.WebControls.TextBox txtPwd;
		protected System.Web.UI.WebControls.RequiredFieldValidator RequiredFieldValidator2;
		protected System.Web.UI.WebControls.TextBox txtPwdConfirm;
		protected System.Web.UI.WebControls.RequiredFieldValidator RequiredFieldValidator3;
		protected System.Web.UI.WebControls.CompareValidator CompareValidator1;
		protected System.Web.UI.WebControls.TextBox txtEmail;
		protected System.Web.UI.WebControls.TextBox txtPhoneNumber;
		protected System.Web.UI.WebControls.TextBox txtMobile;
		protected System.Web.UI.WebControls.TextBox txtFax;
		protected System.Web.UI.WebControls.TextBox txtFirstName;
		protected System.Web.UI.WebControls.TextBox txtLastName;
		protected System.Web.UI.WebControls.RequiredFieldValidator RequiredFieldValidator4;
		protected System.Web.UI.WebControls.RequiredFieldValidator RequiredFieldValidator5;
		protected System.Web.UI.WebControls.RequiredFieldValidator RequiredFieldValidator6;
		protected System.Web.UI.WebControls.TextBox txtAddress;
		
		private string ConnectStr;

		private void Page_Load(object sender, System.EventArgs e)
		{
			// ⿡  ڵ带 ġϿ  ʱȭմϴ.
			ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
		}
		private bool IsMemberExists()
		{
			bool bExist = true;
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "SELECT id FROM Members WHERE id = @ID";
			Cmd.Parameters.Add("@ID", SqlDbType.VarChar, 20);
			Cmd.Parameters["@ID"].Value = txtID.Text;
			try
			{
				Con.Open();
				if(Cmd.ExecuteScalar() == null)
				{
					bExist = false;
				}
			}
			catch (Exception ex) {}
			finally
			{
				Con.Close();
			}
			return bExist;
		}
		#region Web Form ̳ʿ  ڵ
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN:  ȣ ASP.NET Web Form ̳ʿ ʿմϴ.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// ̳  ʿ ޼Դϴ.
		///  ޼  ڵ   ʽÿ.
		/// </summary>
		private void InitializeComponent()
		{    
			this.btnCreateAccount.Click += new System.EventHandler(this.btnCreateAccount_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void AddMember()
		{
			string id = txtID.Text;
			string pwd = txtPwd.Text;

			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "INSERT INTO Members (id, pwd, firstName, lastName, email, phoneNumber, mobile, fax, address) " +
							  "VALUES (@ID, @Pwd, @FirstName, @LastName, @Email, @PhoneNumber, @Mobile, @Fax, @Address)";
			Cmd.Parameters.Add("@ID",SqlDbType.VarChar, 20);
			Cmd.Parameters.Add("@Pwd",SqlDbType.VarChar, 20);
			Cmd.Parameters.Add("@FirstName",SqlDbType.VarChar, 30);
			Cmd.Parameters.Add("@LastName",SqlDbType.VarChar, 30);
			Cmd.Parameters.Add("@Email",SqlDbType.VarChar, 40);
			Cmd.Parameters.Add("@PhoneNumber",SqlDbType.VarChar, 30);
			Cmd.Parameters.Add("@Mobile",SqlDbType.VarChar, 30);
			Cmd.Parameters.Add("@Fax",SqlDbType.VarChar, 30);
			Cmd.Parameters.Add("@Address",SqlDbType.VarChar, 100);

			Cmd.Parameters["@ID"].Value = id;
			Cmd.Parameters["@Pwd"].Value = pwd;
			Cmd.Parameters["@FirstName"].Value = txtFirstName.Text;
			Cmd.Parameters["@LastName"].Value = txtLastName.Text;
			Cmd.Parameters["@Email"].Value = txtEmail.Text;
			Cmd.Parameters["@PhoneNumber"].Value = txtPhoneNumber.Text;
			Cmd.Parameters["@Mobile"].Value = txtMobile.Text;
			Cmd.Parameters["@Fax"].Value = txtFax.Text;
			Cmd.Parameters["@Address"].Value = txtAddress.Text;

			try
			{
				Con.Open();
				Cmd.ExecuteNonQuery();
				
				FormsAuthentication.SetAuthCookie(id, false);
				string script = "<script>";
				script += " alert('Account is created'); ";
				script += " location.href='default.aspx'; ";
				script += "</script>";
				this.RegisterClientScriptBlock("welcome",script);
			}
			catch(Exception ex)
			{
				lblError.Text = "DB Access error !<br/>";
				lblError.Text += ex.Message;
			}
			finally
			{
				Con.Close();
			}

		}
		private void btnCreateAccount_Click(object sender, System.EventArgs e)
		{
			if(IsMemberExists())
				lblError.Text = "ID is already in use.<br><br>Try another ID.";
			else
				AddMember();
		}
	}
}
