using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;


using System.Configuration;
using System.Data.SqlClient;
using System.Web.Security;

namespace OnlineSurvey
{
	/// <summary>
	/// QuestionManager   Դϴ.
	/// </summary>
	
	public class QuestionManager : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.DataList OptionList;
		protected System.Web.UI.WebControls.Label lblError;
		protected System.Web.UI.WebControls.Button btnAddOption;
		protected System.Web.UI.WebControls.TextBox txtAddOption;
		protected System.Web.UI.WebControls.Panel panelAddOption;
	
		private string questionString = null;
		private int type;
		protected System.Web.UI.WebControls.TextBox txtQuestion;
		protected System.Web.UI.WebControls.HyperLink HyperLink1;
		private int surveyID; // question  survey ID

		private bool GetQuestionInfo()
		{
			string questionID = Request.QueryString["questionID"];
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "SELECT * FROM Questions WHERE questionID = @questionID";
			Cmd.Parameters.Add("@questionID", SqlDbType.Int);
			Cmd.Parameters["@questionID"].Value = questionID;
			Con.Open();			
			SqlDataReader dr = Cmd.ExecuteReader(CommandBehavior.CloseConnection);
			if(dr.Read())
			{
				surveyID = (int)dr["surveyID"];
				type = (int)dr["type"];
				questionString = dr["questionString"].ToString();
				dr.Close();
				return true;				
			}
			else 
			{
				dr.Close();
				return false;
			}

		}
		private void OptionListBind()
		{
			string questionID = Request.QueryString["questionID"];
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlDataAdapter Adap = new SqlDataAdapter();			
			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "SELECT optionID, optionString FROM Options WHERE questionID = @questionID";
			Cmd.Parameters.Add("@questionID", SqlDbType.Int);
			Cmd.Parameters["@questionID"].Value = questionID;
			Adap.SelectCommand = Cmd;
			
			DataSet ds = new DataSet();
			Adap.Fill(ds, "options");
			OptionList.DataSource = ds.Tables["options"];
			OptionList.DataBind();
		}
		private void Page_Load(object sender, System.EventArgs e)
		{
			if(Request.QueryString["questionID"] == null)
				Response.Redirect("Default.aspx");
			if(User.Identity.IsAuthenticated)
			{
				if(!GetQuestionInfo()) // question ID ȿ  return
				{
					lblError.Text = "Invalid questionID !";
					return;
				}
				HyperLink1.NavigateUrl = "SurveyManager.aspx?surveyID="+surveyID;
				//TODO permission check
				if(type == 1) // Short Answer
				{
					if(!IsPostBack)
					{
						txtQuestion.Text = questionString;
					}
					lblError.Text = "This Question is Short Answer type.";
				}
				else if(type == 0) // Multiple choice (Only one selection)
				{
					if(!IsPostBack)
					{
						txtQuestion.Text = questionString;
						OptionListBind();
					}
					panelAddOption.Visible = true;
				}
				else 
				{
					lblError.Text = "Not supported Question type!";
				}
			}
		}

		#region Web Form ̳ʿ  ڵ
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN:  ȣ ASP.NET Web Form ̳ʿ ʿմϴ.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// ̳  ʿ ޼Դϴ.
		///  ޼  ڵ   ʽÿ.
		/// </summary>
		private void InitializeComponent()
		{    
			this.OptionList.CancelCommand += new System.Web.UI.WebControls.DataListCommandEventHandler(this.OptionList_CancelCommand);
			this.OptionList.EditCommand += new System.Web.UI.WebControls.DataListCommandEventHandler(this.OptionList_EditCommand);
			this.OptionList.UpdateCommand += new System.Web.UI.WebControls.DataListCommandEventHandler(this.OptionList_UpdateCommand);
			this.OptionList.DeleteCommand += new System.Web.UI.WebControls.DataListCommandEventHandler(this.OptionList_DeleteCommand);
			this.btnAddOption.Click += new System.EventHandler(this.btnAddOption_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void btnAddOption_Click(object sender, System.EventArgs e)
		{
			string optionString = txtAddOption.Text;
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);

			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "INSERT INTO Options (questionID, optionString ) " +
				"VALUES (@questionID, @optionString)";
			Cmd.Parameters.Add("@questionID",SqlDbType.Int);
			Cmd.Parameters.Add("@optionString",SqlDbType.VarChar, 100);

			Cmd.Parameters["@questionID"].Value = Request.QueryString["questionID"];
			Cmd.Parameters["@optionString"].Value = optionString;

			try
			{
				Con.Open();
				Cmd.ExecuteNonQuery();

			}
			catch(Exception ex)
			{
				lblError.Text = "DB Access error !<br/>";
				lblError.Text += ex.Message;
			}
			finally
			{
				Con.Close();
			}
			txtAddOption.Text = "";
			OptionListBind();
		}

		private void OptionList_EditCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
		{
			OptionList.EditItemIndex = e.Item.ItemIndex;
			OptionListBind();
		}

		private void OptionList_UpdateCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
		{
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			string optionString = ((TextBox)e.Item.FindControl("optionString")).Text;
			string optionID = OptionList.DataKeys[e.Item.ItemIndex].ToString();

			string strSQL;
			strSQL = "UPDATE Options SET optionString=@OptionString WHERE optionID = @OptionID";			
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlCommand Cmd = new SqlCommand(strSQL, Con);

			Cmd.Parameters.Add("@OptionString", SqlDbType.VarChar, 50);
			Cmd.Parameters.Add("@OptionID", SqlDbType.Int);			
			Cmd.Parameters["@OptionString"].Value = optionString;
			Cmd.Parameters["@OptionID"].Value = optionID;
			
			Con.Open();
			Cmd.ExecuteNonQuery();
			Con.Close();

			OptionList.EditItemIndex = -1;
			OptionListBind();
		}

		private void OptionList_DeleteCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
		{
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			string strSQL;
			strSQL = "DELETE FROM Options WHERE optionID = @OptionID";
			SqlCommand Cmd = new SqlCommand(strSQL, Con);
			Cmd.Parameters.Add("@OptionID", SqlDbType.Int);
			Cmd.Parameters["@OptionID"].Value = OptionList.DataKeys[e.Item.ItemIndex];
			Con.Open();
			Cmd.ExecuteNonQuery();
			Con.Close();

			OptionList.EditItemIndex = -1;
			OptionListBind();
		}

		private void OptionList_CancelCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
		{
			OptionList.EditItemIndex = -1;
			OptionListBind();
		}
	}
}
