using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using System.Configuration;
using System.Data.SqlClient;

namespace OnlineSurvey
{
	/// <summary>
	/// MakeSurvey   Դϴ.
	/// </summary>
	public class MakeSurvey : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Label lblError;
		protected System.Web.UI.WebControls.RequiredFieldValidator RequiredFieldValidator1;
		protected System.Web.UI.WebControls.RequiredFieldValidator RequiredFieldValidator2;
		protected System.Web.UI.WebControls.TextBox txtTitle;
		protected System.Web.UI.WebControls.TextBox txtDBname;
		protected System.Web.UI.WebControls.Button btnMake;
		private string ConnectStr;

		private void Page_Load(object sender, System.EventArgs e)
		{
			// ⿡  ڵ带 ġϿ  ʱȭմϴ.
			ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
		}

		private void addSurvey()
		{
			string title = txtTitle.Text;
			string dbName = txtDBname.Text;
			string id = User.Identity.Name;

			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "INSERT INTO Surveys (userID, dbName, title ) " +
							  "VALUES (@userID, @dbName, @title)";
			Cmd.Parameters.Add("@userID",SqlDbType.VarChar, 20);
			Cmd.Parameters.Add("@dbName",SqlDbType.VarChar, 20);
			Cmd.Parameters.Add("@title",SqlDbType.VarChar, 50);

			Cmd.Parameters["@userID"].Value = id;
			Cmd.Parameters["@dbName"].Value = dbName;
			Cmd.Parameters["@title"].Value = title;
			
			SqlCommand Cmd2 = new SqlCommand();
			Cmd2.Connection = Con;
			Cmd2.CommandText = "CREATE TABLE " +  dbName + 
								" ( seq int IDENTITY (1, 1) NOT NULL PRIMARY KEY )";

			try
			{
				Con.Open();
				Cmd.ExecuteNonQuery();
				Cmd2.ExecuteNonQuery();

				string script = "<script>";
				script += " alert('Survey is created'); ";
				script += " location.href='default.aspx'; ";
				script += "</script>";
				this.RegisterClientScriptBlock("created",script);
			}
			catch(Exception ex)
			{
				lblError.Text = "DB Access error !<br/>";
				lblError.Text += ex.Message;
			}
			finally
			{
				Con.Close();
			}
		}

		private bool isDBExists()
		{
			bool bExist = true;
			
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "SELECT surveyID FROM Surveys WHERE dbName = @dbName";
			Cmd.Parameters.Add("@dbName", SqlDbType.VarChar, 20);
			Cmd.Parameters["@dbName"].Value = txtDBname.Text;
			try
			{
				Con.Open();
				if(Cmd.ExecuteScalar() == null)
				{
					bExist = false;
				}
			}
			catch (Exception ex) {}
			finally
			{
				Con.Close();
			}
			return bExist;
		}

		#region Web Form ̳ʿ  ڵ
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN:  ȣ ASP.NET Web Form ̳ʿ ʿմϴ.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// ̳  ʿ ޼Դϴ.
		///  ޼  ڵ   ʽÿ.
		/// </summary>
		private void InitializeComponent()
		{    
			this.btnMake.Click += new System.EventHandler(this.btnMake_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void btnMake_Click(object sender, System.EventArgs e)
		{
			if(isDBExists()) // ο  ̸ table  Ѵٸ
			{
				lblError.Text = "DB name is already in use.<br><br>Try another DB name.";
			}
			else 
			{
				addSurvey();
			}
		}
	}
}
