using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using System.Configuration;
using System.Data.SqlClient;
using System.Web.Security;

namespace OnlineSurvey
{
	/// <summary>
	/// _Default   Դϴ.
	/// </summary>
	public class _Default : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.DataList MySurveyList;
		protected System.Web.UI.WebControls.Label lblMySurveyListError;
		protected System.Web.UI.WebControls.DataList PublicSurveyList;

		private void MySurveyBind()
		{
			string id = User.Identity.Name;
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlDataAdapter Adap = new SqlDataAdapter();			
			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "SELECT surveyID, title, surveyCount, questionCount FROM Surveys WHERE userID = @userID";
			Cmd.Parameters.Add("@userID", SqlDbType.VarChar, 20);			
			Cmd.Parameters["@userID"].Value = id;
			Adap.SelectCommand = Cmd;
			
			DataSet ds = new DataSet();
			Adap.Fill(ds, "surveys");
			MySurveyList.DataSource = ds.Tables["surveys"];
			MySurveyList.DataBind();
		}

		private void PublicSurveyBind()
		{
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlDataAdapter Adap = new SqlDataAdapter();			
			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;			
			Cmd.CommandText = "SELECT * FROM Surveys WHERE status = 2";
			/*
			if(User.Identity.IsAuthenticated)
			{
				Cmd.CommandText += " AND userID <> @UserID";
				Cmd.Parameters.Add("@UserID", SqlDbType.VarChar, 20);
				Cmd.Parameters["@UserID"].Value = User.Identity.Name;
			}*/
			Adap.SelectCommand = Cmd;
			
			DataSet ds = new DataSet();
			Adap.Fill(ds, "surveys");
			PublicSurveyList.DataSource = ds.Tables["surveys"];
			PublicSurveyList.DataBind();
		}

		private void Page_Load(object sender, System.EventArgs e)
		{
			if(User.Identity.IsAuthenticated)
			{
				MySurveyList.Visible = true;
				if(!IsPostBack)
				{
					MySurveyBind();
					PublicSurveyBind();
				}
			}
			else 
			{
				PublicSurveyBind();
			}
		}

		#region Web Form ̳ʿ  ڵ
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN:  ȣ ASP.NET Web Form ̳ʿ ʿմϴ.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// ̳  ʿ ޼Դϴ.
		///  ޼  ڵ   ʽÿ.
		/// </summary>
		private void InitializeComponent()
		{    
			this.MySurveyList.ItemCommand += new System.Web.UI.WebControls.DataListCommandEventHandler(this.MySurveyList_ItemCommand);
			this.MySurveyList.CancelCommand += new System.Web.UI.WebControls.DataListCommandEventHandler(this.MySurveyList_CancelCommand);
			this.MySurveyList.EditCommand += new System.Web.UI.WebControls.DataListCommandEventHandler(this.MySurveyList_EditCommand);
			this.MySurveyList.UpdateCommand += new System.Web.UI.WebControls.DataListCommandEventHandler(this.MySurveyList_UpdateCommand);
			this.MySurveyList.DeleteCommand += new System.Web.UI.WebControls.DataListCommandEventHandler(this.MySurveyList_DeleteCommand);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion


		private void MySurveyList_ItemCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
		{
			if(e.CommandName == "manager")
			{
				Response.Redirect("SurveyManager.aspx?surveyID="+ MySurveyList.DataKeys[e.Item.ItemIndex].ToString());
			}
			else if(e.CommandName == "publicRequest")
			{
				string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
				string surveyID = MySurveyList.DataKeys[e.Item.ItemIndex].ToString();

				string strSQL;
				strSQL = "UPDATE Surveys SET status=@status WHERE surveyID = @surveyID";
				
				SqlConnection Con = new SqlConnection(ConnectStr);
				SqlCommand Cmd = new SqlCommand(strSQL, Con);

				Cmd.Parameters.Add("@status", SqlDbType.VarChar, 50);
				Cmd.Parameters.Add("@surveyID", SqlDbType.Int);			
				Cmd.Parameters["@status"].Value = 1;
				Cmd.Parameters["@surveyID"].Value = surveyID;
			
				Con.Open();
				Cmd.ExecuteNonQuery();
				Con.Close();

				MySurveyList.EditItemIndex = -1;
				MySurveyBind();
			}

		}

		private void MySurveyList_EditCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
		{
			MySurveyList.EditItemIndex = e.Item.ItemIndex;
			MySurveyBind();
		}

		private void MySurveyList_UpdateCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
		{
			string title = ((TextBox)e.Item.FindControl("title")).Text;
			string surveyID = MySurveyList.DataKeys[e.Item.ItemIndex].ToString();

			string strSQL;
			strSQL = "UPDATE Surveys SET title=@title WHERE surveyID = @surveyID";
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlCommand Cmd = new SqlCommand(strSQL, Con);

			Cmd.Parameters.Add("@title", SqlDbType.VarChar, 50);
			Cmd.Parameters.Add("@surveyID", SqlDbType.Int);			
			Cmd.Parameters["@title"].Value = title;
			Cmd.Parameters["@surveyID"].Value = surveyID;
			
			Con.Open();
			Cmd.ExecuteNonQuery();
			Con.Close();

			MySurveyList.EditItemIndex = -1;
			MySurveyBind();
			PublicSurveyBind();
		}

		private void DeleteQuestion(string questionID)
		{
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlConnection Con2 = new SqlConnection(ConnectStr);
			string strSQL;
			strSQL = "DELETE FROM Questions WHERE questionID = @questionID";			
			SqlCommand Cmd = new SqlCommand(strSQL, Con);
			Cmd.Parameters.Add("@questionID", SqlDbType.Int);
			Cmd.Parameters["@questionID"].Value = questionID;
			
			SqlCommand Cmd2 = new SqlCommand("SELECT optionID FROM Options WHERE questionID=@questionID",Con2);
			Cmd2.Parameters.Add("@questionID", SqlDbType.Int);
			Cmd2.Parameters["@questionID"].Value = questionID;
			Con2.Open();
			
			Con.Open();				
			SqlTransaction trans = Con.BeginTransaction();
			try
			{
				Cmd.Transaction = trans;
				SqlDataReader dr = Cmd2.ExecuteReader();
				while(dr.Read())
				{
					SqlCommand Cmd3 = new SqlCommand("DELETE FROM Options WHERE optionID = @OptionID",Con);
					Cmd3.Parameters.Add("@OptionID", SqlDbType.Int);
					Cmd3.Parameters["@OptionID"].Value = dr["optionID"];
					Cmd3.Transaction = trans;
					Cmd3.ExecuteNonQuery();
				}
				Cmd.ExecuteNonQuery();
				trans.Commit();
			}	
			catch(Exception ex)
			{
				trans.Rollback();
				lblMySurveyListError.Text = "DB Access error !<br/>";
				lblMySurveyListError.Text += ex.Message;
			}
			finally
			{
				Con.Close();
			}
		}

		private void MySurveyList_DeleteCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
		{
			string dbName;
			string surveyID = MySurveyList.DataKeys[e.Item.ItemIndex].ToString();
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);

			string strSQL0;
			strSQL0 = "SELECT dbName FROM Surveys WHERE surveyID = @surveyID";
			SqlCommand Cmd0 = new SqlCommand(strSQL0, Con);
			Cmd0.Parameters.Add("@surveyID", SqlDbType.Int);
			Cmd0.Parameters["@surveyID"].Value = surveyID;
			try
			{
				Con.Open();
				dbName = Cmd0.ExecuteScalar().ToString();
				Con.Close();
			}
			catch(Exception ex)
			{
				Con.Close();
				return;
			}			
			
			string strSQL;
			strSQL = "DELETE FROM Surveys WHERE surveyID = @surveyID";			
			
			SqlCommand Cmd = new SqlCommand(strSQL, Con);
			Cmd.Parameters.Add("@surveyID", SqlDbType.Int);
			Cmd.Parameters["@surveyID"].Value = surveyID;
			
			string strSQL2;
			strSQL2 = "DROP TABLE " + dbName;
			SqlCommand Cmd2 = new SqlCommand(strSQL2, Con);

			Con.Open();
			Cmd.ExecuteNonQuery();
			Cmd2.ExecuteNonQuery();
			
			
			SqlCommand Cmd3 = new SqlCommand("SELECT questionID FROM Questions WHERE surveyID=@surveyID", Con);
			Cmd3.Parameters.Add("@surveyID", SqlDbType.Int);
			Cmd3.Parameters["@surveyID"].Value = surveyID;

			SqlDataReader dr = Cmd3.ExecuteReader();
			while(dr.Read())
			{
				DeleteQuestion(dr["questionID"].ToString());
			}
			Con.Close();

			MySurveyList.EditItemIndex = -1;
			MySurveyBind();
			PublicSurveyBind();
		}

		private void MySurveyList_CancelCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
		{
			MySurveyList.EditItemIndex = -1;
			MySurveyBind();
		}
	}
}
