namespace OnlineSurvey
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;

	using System.Configuration;
	using System.Data.SqlClient;
	using System.Web.Security;
	/// <summary>
	///		AnswerControl   Դϴ.
	/// </summary>
	
	public class AnswerControl : System.Web.UI.UserControl
	{
		public System.Web.UI.WebControls.RadioButtonList OptionList;
		public System.Web.UI.WebControls.TextBox txtShortAnswer;
		private string questionID;
		public  System.Web.UI.WebControls.Label lblType;
		public int type; // 0 : multiple selection ( one choice ), 2: short answer
		
		private bool GetQuestionInfo()
		{
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "SELECT * FROM Questions WHERE questionID = @questionID";
			Cmd.Parameters.Add("@questionID", SqlDbType.Int);
			Cmd.Parameters["@questionID"].Value = questionID;
			Con.Open();			
			SqlDataReader dr = Cmd.ExecuteReader(CommandBehavior.CloseConnection);
			if(dr.Read())
			{
				//surveyID = (int)dr["surveyID"];
				type = (int)dr["type"];
				lblType.Text = type.ToString();
				//questionString = dr["questionString"].ToString();
				dr.Close();
				return true;				
			}
			else 
			{
				dr.Close();
				return false;
			}
		}
		private void OptionListBind()
		{
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlDataAdapter Adap = new SqlDataAdapter();			
			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "SELECT optionID, optionString FROM Options WHERE questionID = @questionID";
			Cmd.Parameters.Add("@questionID", SqlDbType.Int);
			Cmd.Parameters["@questionID"].Value = questionID;
			Adap.SelectCommand = Cmd;
			
			DataSet ds = new DataSet();
			Adap.Fill(ds, "options");
			OptionList.DataSource = ds.Tables["options"];
			OptionList.DataTextField = "optionString";
			OptionList.DataBind();
		}
		private void Page_Load(object sender, System.EventArgs e)
		{			
			if(!IsPostBack)
			{
				GetQuestionInfo();
				if(type == 0)
				{
					OptionList.Visible = true;
					OptionListBind();
				}
				else if(type == 1)
				{
					txtShortAnswer.Visible = true;
				}
			}			
		}

		public string QuestionID
		{
			set 
			{
				questionID = value;
			}
		}
		#region Web Form ̳ʿ  ڵ
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN:  ȣ ASP.NET Web Form ̳ʿ ʿմϴ.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		///		̳  ʿ ޼Դϴ.  ޼ 
		///		ڵ   ʽÿ.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
