using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using System.Configuration;
using System.Data.SqlClient;
using System.Web.Security;

namespace OnlineSurvey
{
	/// <summary>
	/// Admin   Դϴ.
	/// </summary>
	public class Admin : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.DataList PublicRequestSurveyList;
		protected System.Web.UI.WebControls.Label lblError;
		protected System.Web.UI.WebControls.DataList AllSurveyList;
	
		private void PublicRequestSurveyBind()
		{
			string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
			SqlConnection Con = new SqlConnection(ConnectStr);
			SqlDataAdapter Adap = new SqlDataAdapter();			
			SqlCommand Cmd = new SqlCommand();
			Cmd.Connection = Con;
			Cmd.CommandText = "SELECT * FROM Surveys WHERE status = @Status";
			Cmd.Parameters.Add("@Status", SqlDbType.Int);
			Cmd.Parameters["@Status"].Value = 1;
			Adap.SelectCommand = Cmd;
			
			DataSet ds = new DataSet();
			Adap.Fill(ds, "surveys");
			PublicRequestSurveyList.DataSource = ds.Tables["surveys"];
			PublicRequestSurveyList.DataBind();
		}
		private void Page_Load(object sender, System.EventArgs e)
		{
			if(User.Identity.IsAuthenticated && User.Identity.Name == "admin")
			{
				if(!IsPostBack)
				{
					PublicRequestSurveyBind();
				}
			}
			else 
			{
				lblError.Text = "This Page is only for adminstrator.";
			}
		}

		#region Web Form ̳ʿ  ڵ
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN:  ȣ ASP.NET Web Form ̳ʿ ʿմϴ.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// ̳  ʿ ޼Դϴ.
		///  ޼  ڵ   ʽÿ.
		/// </summary>
		private void InitializeComponent()
		{    
			this.PublicRequestSurveyList.ItemCommand += new System.Web.UI.WebControls.DataListCommandEventHandler(this.PublicRequestSurveyList_ItemCommand);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void PublicRequestSurveyList_ItemCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
		{
			if(e.CommandName == "makePublic")
			{
				string ConnectStr = ConfigurationSettings.AppSettings["ConnectionString"];
				string surveyID = PublicRequestSurveyList.DataKeys[e.Item.ItemIndex].ToString();

				string strSQL;
				strSQL = "UPDATE Surveys SET status=@status WHERE surveyID = @surveyID";
				
				SqlConnection Con = new SqlConnection(ConnectStr);
				SqlCommand Cmd = new SqlCommand(strSQL, Con);

				Cmd.Parameters.Add("@status", SqlDbType.VarChar, 50);
				Cmd.Parameters.Add("@surveyID", SqlDbType.Int);			
				Cmd.Parameters["@status"].Value = 2;
				Cmd.Parameters["@surveyID"].Value = surveyID;
			
				Con.Open();
				Cmd.ExecuteNonQuery();
				Con.Close();

				PublicRequestSurveyList.EditItemIndex = -1;
				PublicRequestSurveyBind();
			}
		}
	}
}
