using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Text;
using System.Net;
using System.IO;
using System.Collections.Specialized;

namespace As2Client
{
	public class MIMEMessage
	{
		public MIMEPart Part;

		public string encode(out WebHeaderCollection msgHeaders)
		{
			msgHeaders = new WebHeaderCollection();
			msgHeaders.Add("MIME-Version", "1.0");

			NameValueCollection partHead;
			string msgBody = Part.encode(out partHead);
			msgHeaders.Add(partHead);
			return msgBody;
		}

		public byte[] decode()
		{
			byte[] result = null;

			return result;
		}
	}

	public class MIMEPart
	{
		public NameValueCollection Headers;
		string body;

		public MIMEPart(string body, NameValueCollection headers)
		{
			this.body = body;
			Headers = headers;
		}

		internal virtual string encode(out NameValueCollection header) {
			header = Headers;
			return body;
		}
	}

	public class MIMEMultiPart : MIMEPart 
	{
		public ArrayList Parts = new ArrayList();
		static int boundary = 0;

		public MIMEMultiPart(NameValueCollection headers) : base(null, headers)
		{
		}

		internal override string encode(out NameValueCollection header) 
		{
			if(boundary==Int32.MaxValue) boundary = 0;
			else boundary++;
			string separator = "------=_Part_"+boundary;

			header = Headers;
			string[] ct = header.GetValues("content-type");
			header.Remove("content-type");
			header.Add("content-type", ct[0]+"; boundary=\""+separator+"\"");

			string body = "";
			foreach(MIMEPart mp in Parts) 
			{
				NameValueCollection partHeaders;
				string partBody = mp.encode(out partHeaders);
				body += separator + "\n" + partHeaders.ToString() + "\n\n" + partBody +"\n";
			}
			body += separator+"--\n";
			return body;
		}
	}
}