
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.io.*;
import java.util.*;
import common.*;

public class Example6 extends DefaultHandler {

	// XML Parser...
	XMLReader parser;

        // Mapping delegates...
        Example6Circle circleMapper = new Example6Circle();
        Example6Square squareMapper = new Example6Square();
        Example6Triangle triangleMapper = new Example6Triangle();
	

	// Local list of different shapes...
	private Vector circles = new Vector();
	private Vector triangles = new Vector();
	private Vector squares = new Vector();


	// Buffer for collecting data from
	// the "characters" SAX event.
	private CharArrayWriter contents = new CharArrayWriter();


	// Constructor with XML Parser...
	Example6( XMLReader parser ) {
        	this.parser = parser;
	}


	// Override methods of the DefaultHandler class
	// to gain notification of SAX Events.
	//
        // See org.xml.sax.ContentHandler for all available events.
	//

	public void startElement( String namespaceURI,
			 	  String localName,
				  String qName,
				  Attributes attr ) throws SAXException {

		contents.reset();

		if ( localName.equals( "Circle" ) ) {
                        Circle aCircle = new Circle();
			aCircle.name = attr.getValue( "name" );
			circles.addElement( aCircle );
			circleMapper.collectCircle( parser, this, aCircle );
		}		

		if ( localName.equals( "Square" ) ) {
                 	Square aSquare = new Square();
			aSquare.name = attr.getValue( "name" );
			squares.addElement( aSquare );
			squareMapper.collectSquare( parser, this, aSquare );
		}		

		if ( localName.equals( "Triangle" ) ) {
			Triangle aTriangle = new Triangle();
			aTriangle.name = attr.getValue( "name" );
			triangles.addElement( aTriangle );
			triangleMapper.collectTriangle( parser, this, aTriangle);
		}		


	} 
	
	public void endElement( String namespaceURI,
			 	  String localName,
				  String qName ) throws SAXException {

		// Nothing left for the Example 6 mapper 
		// to handle in the endElement SAX event.

	} 
	
	public void characters( char[] ch, int start, int length ) 
						throws SAXException {
		// accumulate the contents into a buffer.
		contents.write( ch, start, length );  
        	
	}


	public Vector getCircles() {
        	return circles;
	}

	public Vector getSquares() {
        	return squares;
	}

	public Vector getTriangles() {
        	return triangles;
	}


	public static void main( String[] argv ){
	
		System.out.println( "Example6:" );		
		try {
		
			// Create SAX 2 parser...
			XMLReader xr = XMLReaderFactory.createXMLReader();
			
			// Set the ContentHandler...
			Example6 ex6 = new Example6(xr);
			xr.setContentHandler( ex6 );
						
			// Parse the file...
			xr.parse( new InputSource( 
					new FileReader( "Example6.xml" )) );
					

			// Display all circles to stdout...
			Circle c;
			Vector items = ex6.getCircles();
			Enumeration e = items.elements();
			while( e.hasMoreElements()){
                        	c = (Circle) e.nextElement();
				c.print( System.out );	
			}


			// Display all squares to stdout...
			Square s;
			items = ex6.getSquares();
			e = items.elements();
			while( e.hasMoreElements()){
                        	s = (Square) e.nextElement();
				s.print( System.out );	
			}


			// Display all triangle to stdout...
			Triangle t;
			items = ex6.getTriangles();
			e = items.elements();
			while( e.hasMoreElements()){
                        	t = (Triangle) e.nextElement();
				t.print( System.out );	
			}

			
		}catch ( Exception e )  {
			e.printStackTrace();
		}
			
		

		
	}

}


class Example6Circle extends DefaultHandler {

	

	// Local current circle reference...
        private Circle   currentCircle;

	// Parent...
	ContentHandler parent;

	// XML Parser
	XMLReader parser;

	// Buffer for collecting data from
	// the "characters" SAX event.
	private CharArrayWriter contents = new CharArrayWriter();


	public void collectCircle( XMLReader parser, 
					ContentHandler parent,
					Circle newCircle ) {
		this.parent = parent;
		this.parser = parser;
		parser.setContentHandler( this );
		currentCircle = newCircle;
	}
	

	// Override methods of the DefaultHandler class
	// to gain notification of SAX Events.
	//
        // See org.xml.sax.ContentHandler for all available events.
	//


	public void endElement( String namespaceURI,
			 	  String localName,
				  String qName ) throws SAXException {


		if ( localName.equals( "x" ) ) {
                       	currentCircle.x = Integer.valueOf(contents.toString().trim()).intValue();
		}		

		if ( localName.equals( "y" ) ) {
                       	currentCircle.y = Integer.valueOf(contents.toString().trim()).intValue();
		}

		if ( localName.equals( "width" ) ) {
                       	currentCircle.width = Integer.valueOf(contents.toString().trim()).intValue();
		}

		if ( localName.equals( "height" ) ) {
                       	currentCircle.height = Integer.valueOf(contents.toString().trim()).intValue();
		}

		if ( localName.equals( "Circle" ) ) {
                 	// swap content handler back to parent
			parser.setContentHandler(parent);
		}		



	} 

	public void characters( char[] ch, int start, int length ) 
						throws SAXException {
		// accumulate the contents into a buffer.
		contents.write( ch, start, length );  
        	
	}



}

class Example6Square extends DefaultHandler {

	

	// Local current square reference...


        private Square   currentSquare;

	// Parent...
	ContentHandler parent;

	// XML Parser
	XMLReader parser;

	// Buffer for collecting data from
	// the "characters" SAX event.
	private CharArrayWriter contents = new CharArrayWriter();


	public void collectSquare( XMLReader parser, 
					ContentHandler parent,
					Square newSquare ) {
		this.parent = parent;
		this.parser = parser;
		parser.setContentHandler( this );
		currentSquare = newSquare;
	}
	

	// Override methods of the DefaultHandler class
	// to gain notification of SAX Events.
	//
        // See org.xml.sax.ContentHandler for all available events.
	//


	public void endElement( String namespaceURI,
			 	  String localName,
				  String qName ) throws SAXException {


		if ( localName.equals( "x" ) ) {
                       	currentSquare.x = Integer.valueOf(contents.toString().trim()).intValue();
		}		

		if ( localName.equals( "y" ) ) {
                       	currentSquare.y = Integer.valueOf(contents.toString().trim()).intValue();
		}

		if ( localName.equals( "width" ) ) {
                       	currentSquare.width = Integer.valueOf(contents.toString().trim()).intValue();
		}

		if ( localName.equals( "height" ) ) {
                       	currentSquare.height = Integer.valueOf(contents.toString().trim()).intValue();
		}

		if ( localName.equals( "Square" ) ) {
                 	// swap content handler back to parent
			parser.setContentHandler(parent);
		}		



	} 

	public void characters( char[] ch, int start, int length ) 
						throws SAXException {
		// accumulate the contents into a buffer.
		contents.write( ch, start, length );  
        	
	}


}

class Example6Triangle extends DefaultHandler {

	

	// Local current triangle reference...
        private Triangle currentTriangle;

	// Parent...
	ContentHandler parent;

	// XML Parser
	XMLReader parser;

	// Buffer for collecting data from
	// the "characters" SAX event.
	private CharArrayWriter contents = new CharArrayWriter();


	public void collectTriangle( XMLReader parser, 
					ContentHandler parent,
					Triangle newTriangle ) {
		this.parent = parent;
		this.parser = parser;
		parser.setContentHandler( this );
		currentTriangle = newTriangle;
	}
	

	// Override methods of the DefaultHandler class
	// to gain notification of SAX Events.
	//
        // See org.xml.sax.ContentHandler for all available events.
	//

	public void endElement( String namespaceURI,
			 	  String localName,
				  String qName ) throws SAXException {


		if ( localName.equals( "x" ) ) {
                       	currentTriangle.x = Integer.valueOf(contents.toString().trim()).intValue();
		}		

		if ( localName.equals( "y" ) ) {
                       	currentTriangle.y = Integer.valueOf(contents.toString().trim()).intValue();
		}

		if ( localName.equals( "width" ) ) {
                       	currentTriangle.width = Integer.valueOf(contents.toString().trim()).intValue();
		}

		if ( localName.equals( "height" ) ) {
                       	currentTriangle.height = Integer.valueOf(contents.toString().trim()).intValue();
		}

		if ( localName.equals( "Triangle" ) ) {
                 	// swap content handler back to parent
			parser.setContentHandler(parent);
		}		



	} 

	public void characters( char[] ch, int start, int length ) 
						throws SAXException {
		// accumulate the contents into a buffer.
		contents.write( ch, start, length );  
        	
	}


}
