
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.io.*;
import java.util.*;
import common.*;

public class Example5 extends DefaultHandler {

	// Flags to help us capture the contents 
	// of a tagged element.
	private boolean inCircle      = false;
	private boolean inTriangle    = false;
	private boolean inSquare      = false;


	// Local list of different shapes...
	private Vector triangles = new Vector();
	private Vector squares = new Vector();
	private Vector circles = new Vector();

	// Local current shape references...
	private Triangle currentTriangle;
        private Circle   currentCircle;
	private Square   currentSquare;

	// Buffer for collecting data from
	// the "characters" SAX event.
	private CharArrayWriter contents = new CharArrayWriter();



	// Override methods of the DefaultHandler class
	// to gain notification of SAX Events.
	//
        // See org.xml.sax.ContentHandler for all available events.
	//

	public void startElement( String namespaceURI,
			 	  String localName,
				  String qName,
				  Attributes attr ) throws SAXException {

		contents.reset();

		if ( localName.equals( "Circle" ) ) {
                 	inCircle = true;
                        currentCircle = new Circle();
			currentCircle.name = attr.getValue( "name" );
			circles.addElement( currentCircle );
		}		

		if ( localName.equals( "Square" ) ) {
                 	inSquare = true;
			currentSquare = new Square();
			currentSquare.name = attr.getValue( "name" );
			squares.addElement( currentSquare );
		}		

		if ( localName.equals( "Triangle" ) ) {
                 	inTriangle = true;
			currentTriangle = new Triangle();
			currentTriangle.name = attr.getValue( "name" );
			triangles.addElement( currentTriangle );
		}		


	} 
	
	public void endElement( String namespaceURI,
			 	  String localName,
				  String qName ) throws SAXException {


		if ( localName.equals( "x" ) ) {
			if ( inCircle ) {
                        	currentCircle.x = Integer.valueOf(contents.toString().trim()).intValue();
			}
			else if ( inSquare ) {
                        	currentSquare.x = Integer.valueOf(contents.toString().trim()).intValue();
			} 
			else {
                        	currentTriangle.x = Integer.valueOf(contents.toString().trim()).intValue();
			}
		}		

		if ( localName.equals( "y" ) ) {
			if ( inCircle ) {
                        	currentCircle.y = Integer.valueOf(contents.toString().trim()).intValue();
			}
			else if ( inSquare ) {
                        	currentSquare.y = Integer.valueOf(contents.toString().trim()).intValue();
			} 
			else {
                        	currentTriangle.y = Integer.valueOf(contents.toString().trim()).intValue();
			}
		}		

		if ( localName.equals( "width" ) ) {
			if ( inCircle ) {
                        	currentCircle.width = Integer.valueOf(contents.toString().trim()).intValue();
			}
			else if ( inSquare ) {
                        	currentSquare.width = Integer.valueOf(contents.toString().trim()).intValue();
			} 
			else {
                        	currentTriangle.width = Integer.valueOf(contents.toString().trim()).intValue();
			}
		}		

		if ( localName.equals( "height" ) ) {
			if ( inCircle ) {
                        	currentCircle.height = Integer.valueOf(contents.toString().trim()).intValue();
			}
			else if ( inSquare ) {
                        	currentSquare.height = Integer.valueOf(contents.toString().trim()).intValue();
			} 
			else {
                        	currentTriangle.height = Integer.valueOf(contents.toString().trim()).intValue();
			}
		}		

		if ( localName.equals( "Circle" ) ) {
                 	inCircle = false;
		}		

		if ( localName.equals( "Square" ) ) {
                 	inSquare = false;
		}		

		if ( localName.equals( "Triangle" ) ) {
                 	inTriangle = false;
		}		



	} 
	
	public void characters( char[] ch, int start, int length ) 
						throws SAXException {
		// accumulate the contents into a buffer.
		contents.write( ch, start, length );  
        	
	}


	public Vector getCircles() {
        	return circles;
	}

	public Vector getSquares() {
        	return squares;
	}

	public Vector getTriangles() {
        	return triangles;
	}


	public static void main( String[] argv ){
	
		System.out.println( "Example5:" );		
		try {
		
			// Create SAX 2 parser...
			XMLReader xr = XMLReaderFactory.createXMLReader();
			
			// Set the ContentHandler...
			Example5 ex5 = new Example5();
			xr.setContentHandler( ex5 );
						
			// Parse the file...
			xr.parse( new InputSource( 
					new FileReader( "Example5.xml" )) );
					

			// Display all circles to stdout...
			Circle c;
			Vector items = ex5.getCircles();
			Enumeration e = items.elements();
			while( e.hasMoreElements()){
                        	c = (Circle) e.nextElement();
				c.print( System.out );	
			}


			// Display all squares to stdout...
			Square s;
			items = ex5.getSquares();
			e = items.elements();
			while( e.hasMoreElements()){
                        	s = (Square) e.nextElement();
				s.print( System.out );	
			}


			// Display all triangle to stdout...
			Triangle t;
			items = ex5.getTriangles();
			e = items.elements();
			while( e.hasMoreElements()){
                        	t = (Triangle) e.nextElement();
				t.print( System.out );	
			}

			
		}catch ( Exception e )  {
			e.printStackTrace();
		}
			
		

		
	}

}
